/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbb.dc.services.utils.CommonUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        Element root = new Element("Message");
        JDomUtils.addChild((Element)root, (Element)CommonUtil.buildHead("B2EActTrsDetailQry", Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)body, (String)"Currency", (String)request.getBankCurrency());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        CommonUtil.resSuccessCheck(rspStr);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = request.getAcnt();
        Element element = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element child = element.getChild("Body").getChild("List");
        if (child == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deList\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]));
        }
        List list = child.getChildren("Map");
        if (list.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        for (Element row : list) {
            DetailInfo detail = new DetailInfo();
            String currencyCode = row.getChildTextTrim("Currency");
            String payeeAcNo = row.getChildTextTrim("PartnerAcct");
            String payeeAcName = row.getChildTextTrim("PartnerAcName");
            String PayeeBankName = row.getChildTextTrim("PayeeBankName");
            detail.setCurrency(StringUtils.isEmpty((String)currencyCode) ? request.getBankCurrency() : currencyCode);
            detail.setOppAccNo(payeeAcNo);
            detail.setOppAccName(payeeAcName);
            detail.setOppBankName(PayeeBankName);
            detail.setAccName(acnt.getAccName());
            detail.setAccNo(acnt.getAccNo());
            String transferDate = row.getChildTextTrim("TransDate");
            String transferTime = row.getChildTextTrim("TransTime");
            detail.setTransDate(LocalDateUtil.parserDate((String)transferDate, (String)"yyyy-MM-dd"));
            detail.setTransTime(LocalDateUtil.parseDateTime((String)(transferDate + " " + transferTime), (String)"yyyy-MM-dd HH:mm:ss"));
            String amount = row.getChildTextTrim("Amount");
            BigDecimal payAmount = BigDecimalHelper.str2BigDecimalForBalance((String)amount, (Boolean)true);
            String CDFlag = row.getChildTextTrim("Type");
            if (CDFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(payAmount);
                detail.setCreditAmount(BigDecimal.ZERO);
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(BigDecimal.ZERO);
                detail.setCreditAmount(payAmount);
            }
            String balance = row.getChildTextTrim("Balance");
            detail.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)true));
            String Remark = row.getChildText("Remark");
            detail.setExplanation(Remark);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsDetailQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2/\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = "/web_eibs/B2EActTrsDetailQry.do?userPassword=" + RequestContextUtils.getParameter().getBankParameter("password") + "&SIGDATA=1";
        factory.setUri(uri);
        super.configFactory(factory);
    }
}

