/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbb.dc.services.payment.single;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbb.dc.services.utils.CommonUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element element = new Element("Message");
        JDomUtils.addChild((Element)element, (Element)CommonUtil.buildHead("B2EDraftStockQry", Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)element, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"OldERPJnlNo", (String)paymentInfo.getBankDetailSeqId());
        String testEnvTime = RequestContextUtils.getParameter().getBankParameter("testEnvTime");
        if (StringUtils.isEmpty((String)testEnvTime)) {
            JDomUtils.addChild((Element)Map2, (String)"OldTrsDate", (String)LocalDateUtil.formatDate((LocalDate)paymentInfo.getSubmitSuccessTime().toLocalDate(), (String)"yyyy-MM-dd"));
        } else {
            JDomUtils.addChild((Element)Map2, (String)"OldTrsDate", (String)testEnvTime);
        }
        JDomUtils.addChild((Element)Map2, (String)"PayAcnt", (String)paymentInfo.getAccNo());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)element, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element child = root.getChild("Body").getChild("List");
        if (child == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deList\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]));
        }
        List list = child.getChildren("Map");
        if (list.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
        } else {
            for (Element element : list) {
                String returnCode = element.getChildText("TranStat");
                String msg = element.getChildText("TranStatMsg");
                if ("000000".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)returnCode, (String)msg);
                    continue;
                }
                if ("000001".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)returnCode, (String)msg);
                    continue;
                }
                if ("000002".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)returnCode, (String)msg);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)returnCode, (String)msg);
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EDraftStockQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8\u67e5\u8be2", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = "/web_eibs/B2EDraftStockQry.do?userPassword=" + RequestContextUtils.getParameter().getBankParameter("password") + "&SIGDATA=1";
        factory.setUri(uri);
        super.configFactory(factory);
    }
}

