/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.payment.allocation.AllocationPaymentImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.company.CompanyPaymentImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.individual.IndividualPaymentImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.linkpay.LinkPaymentImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.oversea.OverseaPayImpl;
import kd.ebg.aqap.banks.cib.dc.services.payment.salarynew.SalaryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.setPayRouteTrace(paymentInfo, this.getBusiImplInfo(paymentInfo));
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append(this.getPaymentPropertyTranslate("batchSeqID=")).append(paymentInfo.getBatchSeqId());
        packageKey.append(";");
        if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo, busiImplInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
        } else if (this.isPay(paymentInfo)) {
            if (this.isSalaryUseCN(paymentInfo)) {
                this.setSubBizType4Salary(paymentInfo, busiImplInfo);
            } else if (this.isTransferUseCN(paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
            } else if (this.isIndividual(paymentInfo)) {
                paymentInfo.setToIndividual("true");
                this.setImplClassName(paymentInfo, IndividualPaymentImpl.class.getName());
            } else {
                paymentInfo.setToIndividual("false");
                this.setImplClassName(paymentInfo, CompanyPaymentImpl.class.getName());
            }
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, LinkPaymentImpl.class.getName());
        } else if (this.isPay_for_overseaPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, OverseaPayImpl.class.getName());
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        paymentInfo.setToIndividual("true");
        if (this.isReimUseCN(paymentInfo)) {
            this.setImplClassName(paymentInfo, IndividualPaymentImpl.class.getName());
        } else if (this.isSalaryUseCN(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                if (this.isChooseNewSalary()) {
                    this.setImplClassName(paymentInfo, SalaryPaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cib.dc.services.payment.salary.SalaryPaymentImpl.class.getName());
                }
            } else {
                this.setImplClassName(paymentInfo, SalaryPaymentImpl.class.getName());
            }
        }
    }

    public boolean isChooseNewSalary() {
        return this.assertBusinessConfig("cib_dc_salary_interface", "ASYNPAYOFFTRNRQ");
    }

    public boolean isAllocationToCompany() {
        return this.assertBusinessConfig("cib_dc_allocation", "XFERTRNRQ");
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        if (this.isAllocationToCompany()) {
            paymentInfo.setToIndividual("false");
            this.setImplClassName(paymentInfo, CompanyPaymentImpl.class.getName());
        } else {
            paymentInfo.setToIndividual("false");
            this.setImplClassName(paymentInfo, AllocationPaymentImpl.class.getName());
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

