/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.agency;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Constants;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.agency.PayCodeUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Parser
implements CIB_DC_Constants {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse1 = this.parserPayResponse(paymentInfos, root);
        if (!"0".equalsIgnoreCase(bankResponse1.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse1.getResponseCode(), (String)bankResponse1.getResponseMessage());
            return;
        }
        Element secMsg = JDomUtils.getChildElement((Element)root, (String)"SECURITIES_MSGSRSV1");
        Element asynbatchmrchagenttrnrs = JDomUtils.getChildElementNotNull((Element)secMsg, (String)"ASYNBATCHMRCHAGENTTRNRS");
        Element rsbody = JDomUtils.getChildElement((Element)asynbatchmrchagenttrnrs, (String)"RSBODY");
        Element xferprcsts = JDomUtils.getChildElement((Element)rsbody, (String)"XFERPRCSTS");
        BankResponse response = new BankResponse();
        response.setResponseCode(JDomUtils.getChildTextTrim((Element)xferprcsts, (String)"XFERPRCCODE"));
        response.setResponseMessage(JDomUtils.getChildTextTrim((Element)xferprcsts, (String)"MESSAGE"));
        HashMap<String, BankResponse> bankReturnStatusMap = new HashMap<String, BankResponse>();
        String xferinfotext = JDomUtils.getChildText((Element)rsbody, (String)"XFERINFOTEXT");
        if (!StringUtils.isEmpty((String)xferinfotext)) {
            String[] strings;
            for (String str : strings = StringUtils.split((String)xferinfotext, (String)"\n")) {
                String[] strings2 = StringUtils.split((String)str, (String)"|");
                BankResponse bankResp = new BankResponse();
                bankResp.setResponseCode(strings2[11]);
                bankResp.setResponseMessage(strings2[12]);
                bankReturnStatusMap.put(strings2[1], bankResp);
            }
        }
        PayCodeUtils.setPaymentInfoStatus(paymentInfos, response, bankReturnStatusMap);
    }

    private BankResponse parserPayResponse(PaymentInfo[] paymentInfos, Element root) throws EBServiceException {
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element asynbatchmrchagenttrnrs = JDomUtils.getChildElement((Element)secmsg, (String)"ASYNBATCHMRCHAGENTTRNRS");
        String trnuid = JDomUtils.getChildTextNotNull((Element)asynbatchmrchagenttrnrs, (String)"TRNUID");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)asynbatchmrchagenttrnrs, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        if (!paymentInfos[0].getBankBatchSeqId().equalsIgnoreCase(trnuid)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u4e0d\u5339\u914d\u3002", (String)"Parser_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)message);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u4e0d\u5339\u914d\u3002", (String)"Parser_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        return bankResponse;
    }
}

