/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salary;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.salary.SalaryCodeUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayParser {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = this.parserSalaryResponse(paymentInfos, root);
        if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        Element secMsg = JDomUtils.getChildElement((Element)root, (String)"SECURITIES_MSGSRSV1");
        Element rpayofftrnrs = JDomUtils.getChildElementNotNull((Element)secMsg, (String)"RPAYOFFTRNRS");
        Element rpayoffrs = JDomUtils.getChildElement((Element)rpayofftrnrs, (String)"RPAYOFFRS");
        Element rpayoffinfo = JDomUtils.getChildElement((Element)rpayoffrs, (String)"RPAYOFFINFO");
        Element acctfrom = JDomUtils.getChildElement((Element)rpayoffinfo, (String)"ACCTFROM");
        String accNo = JDomUtils.getChildText((Element)acctfrom, (String)"ACCTID");
        Element rpayoffList = JDomUtils.getChildElement((Element)rpayoffinfo, (String)"RPAYOFFLIST");
        List rpayoffs = rpayoffList.getChildren("RPAYOFF");
        if (null == rpayoffs || rpayoffs.size() == 0) {
            Element XFERPRCSTS = rpayoffrs.getChild("XFERPRCSTS");
            if (null != XFERPRCSTS) {
                String XFERPRCCODE = XFERPRCSTS.getChildText("XFERPRCCODE");
                String MESSAGE = XFERPRCSTS.getChildText("MESSAGE");
                if ("WAIT_FOR_AUDIT".equals(XFERPRCCODE)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCCODE, (String)MESSAGE);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PayParser_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCCODE, (String)MESSAGE);
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PayParser_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            }
        } else {
            HashMap<String, BankResponse> bankReturnStatusMap = new HashMap<String, BankResponse>(rpayoffs.size() + rpayoffs.size() >> 3);
            for (Element rpInfo : rpayoffs) {
                String detialSequence = JDomUtils.getChildText((Element)rpInfo, (String)"INDX");
                String status = JDomUtils.getChildText((Element)rpInfo, (String)"STATUS");
                String errorMsg = JDomUtils.getChildText((Element)rpInfo, (String)"ERRMSG");
                BankResponse bankResp = new BankResponse();
                bankResp.setResponseCode(status);
                bankResp.setResponseMessage(errorMsg);
                bankReturnStatusMap.put(detialSequence, bankResp);
            }
            SalaryCodeUtils.setPaymentInfoStatus(bankReturnStatusMap, paymentInfos);
        }
    }

    private BankResponse parserSalaryResponse(PaymentInfo[] paymentInfos, Element root) throws EBServiceException {
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element rpaytrnrs = JDomUtils.getChildElement((Element)secmsg, (String)"RPAYOFFTRNRS");
        String trnuid = JDomUtils.getChildTextNotNull((Element)rpaytrnrs, (String)"TRNUID");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)rpaytrnrs, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        if (!paymentInfos[0].getBankBatchSeqId().equalsIgnoreCase(trnuid)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u4e0d\u5339\u914d\u3002", (String)"PayParser_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)message);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u4e0d\u5339\u914d\u3002", (String)"PayParser_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        return bankResponse;
    }
}

