/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.utils;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import netbank.firm.base.SystemProperty;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.handler.DefaultFileChannelInitializer;
import netbank.firm.handler.DefaultRequestFileHandler;
import netbank.firm.handler.DefaultResponseFileHandler;
import netbank.firm.model.UploadRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jdom2.Element;

public class FileUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FileUtil.class);
    private static FileUtil instance = new FileUtil();
    private String proxyHost;
    private int proxyPort;
    private int blockSize;
    private int startBlockId;
    private int connectionTimeOut;
    private String receivePath;
    private long maxSize = 0xF00000L;

    public static FileUtil getInstance() {
        return instance;
    }

    private void init(String ip, int filePort, String fileReceivePath) throws DcfirmException {
        try {
            this.proxyHost = ip;
            this.proxyPort = filePort;
            this.receivePath = fileReceivePath;
            this.blockSize = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.blockSize", "4096"));
            this.startBlockId = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.startBlockId", "1"));
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), e.getMessage());
        }
        if (this.blockSize < 1024 || this.blockSize > 8192) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "block size between 1024 and 8192");
        }
        if (this.startBlockId < 1) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "startNum must be lager than 1");
        }
        this.connectionTimeOut = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.connection.outtime.seconds", "60"));
    }

    private void appendResponseFilelHandler(ChannelFuture ch, File sendFile, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        DefaultResponseFileHandler defaultResponseFileHandler = new DefaultResponseFileHandler();
        if (sendFile != null) {
            if (!sendFile.exists()) {
                throw new FileNotFoundException();
            }
            defaultResponseFileHandler.setSendFile(sendFile);
            defaultResponseFileHandler.setBlockSize(this.blockSize);
            defaultResponseFileHandler.setStartBlockId(this.startBlockId);
        }
        defaultResponseFileHandler.setPromise(promise);
        p.addLast("sendFile", (ChannelHandler)defaultResponseFileHandler);
    }

    private void appendRequestFileHandler(ChannelFuture ch, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        String receivePath = SystemProperty.getInstance().getProperty("file.receive.path", true);
        DefaultRequestFileHandler requestFileHandler = new DefaultRequestFileHandler();
        requestFileHandler.setPath(receivePath);
        requestFileHandler.setPromise(promise);
        p.addLast("re", (ChannelHandler)requestFileHandler);
    }

    private void checkFileLength(File file) throws DcfirmException {
        long fileLength = file.length();
        if (fileLength > this.maxSize) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), "file size over[" + this.maxSize + "]");
        }
    }

    public String uploadFile(File sendFile) throws Exception {
        String fileMac = "";
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String filePort = RequestContextUtils.getBankParameterValue((String)"fileport");
        String path = RequestContextUtils.getBankParameterValue((String)"contractPath");
        if (StringUtils.isEmpty((String)filePort)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f02\u6b65\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3\u9700\u8981\u914d\u7f6e\"\u6587\u4ef6\u4f20\u8f93\u7aef\u53e3\u53f7\"\uff0c\u8bf7\u5728\u3010\u94f6\u4f01\u4e91-\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e-\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u3011\u4e2d\u7ef4\u62a4\u3002", (String)"FileUtil_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)path)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f02\u6b65\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3\u9700\u8981\u914d\u7f6e\"\u524d\u7f6e\u673a\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\"\uff0c\u8bf7\u5728 \u3010\u94f6\u4f01\u4e91-\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e-\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u3011\u4e2d\u7ef4\u62a4\u3002", (String)"FileUtil_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        this.init(ip, Integer.parseInt(filePort), path);
        this.checkFileLength(sendFile);
        if (sendFile == null || sendFile.isDirectory()) {
            throw new DcfirmException(ExceptionCode.C005);
        }
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)nioEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeOut);
            ChannelFuture ch = b.connect(this.proxyHost, this.proxyPort).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    throw new DcfirmException(ExceptionCode.B214, future.cause());
                }
            }));
            this.appendResponseFilelHandler(ch, sendFile, (ChannelPromise)promise);
            ch.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    logger.error("error: ", future.cause());
                    throw new DcfirmException(ExceptionCode.C001.getCode(), future.cause().toString());
                }
                String fileName = sendFile.getName();
                String body = fileName.substring(fileName.lastIndexOf(92) + 1);
                UploadRequest auth = new UploadRequest("101", body);
                future.channel().writeAndFlush((Object)auth).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }));
            promise.await(120L, TimeUnit.SECONDS);
            ch.channel().closeFuture().await(120L, TimeUnit.SECONDS);
            AttributeKey ak = AttributeKey.valueOf((String)"FileID");
            fileMac = (String)ch.channel().attr(ak).get();
            logger.info("upload filemac:" + fileMac);
            ch.channel().closeFuture().sync();
            String string = fileMac;
            return string;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new DcfirmException(ExceptionCode.C002.getCode(), e.getMessage());
        }
        finally {
            nioEventLoopGroup.shutdownGracefully();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadFileByHttp(File sendFile) throws Exception {
        StringBuilder requestUrl = new StringBuilder();
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        requestUrl.append("http://").append(ip);
        String filePort = RequestContextUtils.getBankParameterValue((String)"fileport");
        requestUrl.append(":").append(filePort);
        requestUrl.append("/upload");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(requestUrl.toString());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", sendFile, ContentType.MULTIPART_FORM_DATA, sendFile.getName());
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            builder.addTextBody("bizCode", "101", contentType);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String file_id;
                HttpEntity responseEntity = response.getEntity();
                String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                Element element = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
                Element file_info = element.getChild("FILE_INFO");
                String string = file_id = JDomUtils.getChildText((Element)file_info, (String)"FILE_ID");
                return string;
            }
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + statusCode);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56dehttp\u72b6\u6001\u7801%s", (String)"AbstractAttachmentImpl_3", (String)"ebg-aqap-business", (Object[])new Object[0]), statusCode));
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"AbstractAttachmentImpl_4", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }
}

