/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.payment.allocation;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayPacker.class);

    public static String packQueryPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String tr_code = "200205";
        String req_no = Sequence.genSequence();
        Element ap = TPacker.createCommonHead(tr_code, req_no);
        Element body = ap.getChild("body");
        PaymentInfo paymentInfo = paymentInfos.get(0);
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfo.getPackageId());
        String d = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)d);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }
}

