/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jjccb.cmp.services.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jjccb.cmp.services.payment.salary.QueryPayImpl;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Common;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.FileUploadUtil;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger log = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        StringBuilder sb = new StringBuilder("acno|cur_code|acname|cardflag|amt|postscript|");
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            BigDecimal amt = ((PaymentInfo)paymentInfos.get(i)).getAmount();
            totalAmt = totalAmt.add(amt);
            sb.append("\r\n");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getCurrency()).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append("|");
            sb.append("").append("|");
            String amount = amt.setScale(2, 1).toPlainString();
            sb.append(amount).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append("|");
        }
        String tr_code = "300002";
        Element ap = Packer.createCommonHead(tr_code, ((PaymentInfo)paymentInfos.get(0)).getPackageId(), "1");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"vir_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"vir_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0001");
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmt.setScale(2, 1).toPlainString());
        JDomUtils.addChild((Element)body, (String)"count", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"qry_auth", (String)"");
        String fileName = ((PaymentInfo)paymentInfos.get(0)).getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"6");
        JDomUtils.addChild((Element)body, (String)"record_num", (String)(paymentInfos.size() + ""));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDecAndPrettyFormat((Element)ap, (String)encoding);
        this.log.info("---\u4ee3\u53d1\u6587\u4ef6\u5185\u5bb9:{}", (Object)sb.toString());
        try {
            FileUploadUtil fileUploadUtil = new FileUploadUtil(sb.toString());
            fileUploadUtil.doBiz(fileName);
        }
        catch (Exception e) {
            this.log.error("###[\u4ee3\u53d1\u5de5\u8d44]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        String serialNo = head.getChildTextTrim("serial_no");
        EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)serialNo);
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

