/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment.group;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.SCNXDCMetaDataImpl;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = CommonPacker.packHeader(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"PG_NO", (String)"1");
        JDomUtils.addChild((Element)body, (String)"PG_SIZE", (String)"50");
        JDomUtils.addChild((Element)body, (String)"BIZFLOW", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NM", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NO", (String)"");
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NM", (String)"");
        String dateStr = LocalDateUtil.formatDate((LocalDateTime)paymentInfo.getSubmitSuccessTime());
        JDomUtils.addChild((Element)body, (String)"BGN_DT", (String)dateStr);
        JDomUtils.addChild((Element)body, (String)"END_DT", (String)dateStr);
        JDomUtils.addChild((Element)body, (String)"TXSTUSCD", (String)"A");
        JDomUtils.addChild((Element)body, (String)"START_AMT", (String)"");
        JDomUtils.addChild((Element)body, (String)"END_AMT", (String)"");
        JDomUtils.addChild((Element)body, (String)"GRPPRNTCORPCUSTNO", (String)RequestContextUtils.getBankParameterValue((String)SCNXDCMetaDataImpl.custom_no));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CommonParser.parserHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element body = root.getChild("BODY");
            Element loop = body.getChild("LOOP");
            List details = loop.getChildren("DETAIL");
            if (details != null && details.size() == 1) {
                Element detail = (Element)details.get(0);
                String txstuscd = detail.getChildText("TXSTUSCD");
                String msg = detail.getChildText("MSG");
                if ("S".equalsIgnoreCase(txstuscd)) {
                    EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUCCESS, (String)"", (String)txstuscd, (String)msg);
                } else if ("P".equalsIgnoreCase(txstuscd) || "C".equalsIgnoreCase(txstuscd)) {
                    EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)txstuscd, (String)msg);
                } else if ("F".equalsIgnoreCase(txstuscd)) {
                    EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)"", (String)txstuscd, (String)msg);
                } else {
                    EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)txstuscd, (String)msg);
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a\u6216\u8005\u4e0d\u552f\u4e00\u3002", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "TC014";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u5bf9\u5916\u4ed8\u6b3e\u67e5\u8be2", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }
}

