/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.banks.adbc.dc.AdbcDcBankBusinessConfig;
import kd.ebg.aqap.banks.adbc.dc.constants.Constants;
import kd.ebg.aqap.banks.adbc.dc.services.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.adbc.dc.services.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.adbc.dc.services.detail.DetailImpl;
import kd.ebg.aqap.banks.adbc.dc.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.adbc.dc.services.payment.batchPay.BatchPayImpl;
import kd.ebg.aqap.banks.adbc.dc.services.payment.batchPay.BatchQueryPayImpl;
import kd.ebg.aqap.banks.adbc.dc.services.payment.singlePay.SinglePayImpl;
import kd.ebg.aqap.banks.adbc.dc.services.payment.singlePay.SingleQueryPayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class AdbcDcMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String certType = "cert_type";
    public static final String certNo = "cert_no";
    public static final String customerId = "customer_id";
    public static final String userId = "user_id";

    public void metaDataInit() {
        this.setBankName(Constants.BANK_NAME);
        this.setBankVersionID("ADBC_DC");
        this.setBankShortName("ADBC");
        this.setBankVersionName(Constants.BANK_VERSIOIN_NAME);
        this.setDescription(Constants.BANK_NAME);
        this.setKeyNames(Lists.newArrayList());
    }

    public void baseConfigInit() {
        this.setExchangeProtocol("TCP");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)userId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4f01\u4e1a\u7528\u6237\u7f16\u53f7", "AdbcDcMetaDataImpl_0", "ebg-aqap-banks-adbc-dc"), (String)"", (boolean)false, (boolean)false)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{TodayBalanceImpl.class, HisBalanceImpl.class, DetailImpl.class, BatchPayImpl.class, BatchQueryPayImpl.class, SinglePayImpl.class, SingleQueryPayImpl.class, PretreatmentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new AdbcDcBankBusinessConfig();
    }

    public Map<String, Map<String, String>> getDetailNoRule() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HashMap ruleMap = Maps.newHashMapWithExpectedSize((int)16);
        ruleMap.put("accNo", "accNo");
        ruleMap.put("oppAccNo", "OfferSetAccount");
        ruleMap.put("transDate", "transDate");
        ruleMap.put("Amount", "Amount");
        ruleMap.put("cdFlag", "Flag");
        ruleMap.put("serialNo", "BankSerial");
        result.put("default", ruleMap);
        return result;
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("TransDate", DetailUniqueTypeEnum.TIMESTAMP.getType());
        result.put("BankSerial", DetailUniqueTypeEnum.STRING.getType());
        result.put("Flag", DetailUniqueTypeEnum.STRING.getType());
        result.put("Amount", DetailUniqueTypeEnum.BIGDECIMAL.getType());
        result.put("Flag_1", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

