/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.adbc.dc.services.detail.DetailPacker;
import kd.ebg.aqap.banks.adbc.dc.services.detail.DetailParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.myDetail(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.myDetail(request);
    }

    public EBBankDetailResponse myDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        ArrayList detailInfoList = new ArrayList(8);
        while (!startDate.isAfter(endDate)) {
            EBBankDetailResponse bankDetailResponse = this.doBiz(request);
            detailInfoList.addAll(bankDetailResponse.getDetails());
            startDate = startDate.plusDays(1L);
            request.setStartDate(startDate);
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return new DetailPacker().packDetail(bankDetailRequest, this.getCurrentPage());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        EBBankDetailResponse bankDetailResponse = new EBBankDetailResponse();
        DetailParser detailParser = new DetailParser();
        List<DetailInfo> detailInfos = detailParser.parseDetail(request, rspStr, "");
        bankDetailResponse.setDetails(detailInfos);
        return bankDetailResponse;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "eb.qry.023.1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u53ca\u5386\u53f2\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]);
    }
}

