/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.payment.batchPay;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import kd.ebg.aqap.banks.adbc.dc.services.Packer;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class QueryPayPacker {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayPacker.class);

    public String packQueryPay(PaymentInfo[] paymentInfos) {
        String body = this.createBody(paymentInfos);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.biz.005.1", bodyLen, paymentInfos);
        String reqMsg = header + body;
        return reqMsg;
    }

    private String createBody(PaymentInfo[] paymentInfos) {
        StringBuilder sbBody = new StringBuilder();
        BigDecimal amount = BigDecimal.ZERO;
        try {
            String messageCode = "";
            if (paymentInfos != null) {
                String id = paymentInfos[0].getBankBatchSeqId();
                if (id.length() <= 16) {
                    messageCode = String.format("%-16s", id);
                } else if (id.length() > 16) {
                    messageCode = id.substring(id.length() - 16);
                }
                String requestTime = LocalDateUtil.formatDate((LocalDate)paymentInfos[0].getRequestTime().toLocalDate(), (String)"yyyy-MM-dd");
                String sendCode = RequestContextUtils.getParameter().getBankParameter("user_id");
                sbBody.append("<?xml version=\"1.0\" encoding=\"").append(RequestContextUtils.getCharset()).append("\"?>\r\n");
                sbBody.append("<Document xmlns=\"").append("eb.biz.005.1").append("\">\r\n");
                sbBody.append("<OriginalInfo>");
                sbBody.append("<OSendCode>").append(sendCode).append("</OSendCode>");
                sbBody.append("<OMessageCode>").append(messageCode).append("</OMessageCode>");
                sbBody.append("<OMesgCode>").append("eb.biz.003.1").append("</OMesgCode>");
                sbBody.append("<OTransDate>").append(requestTime).append("</OTransDate>");
                sbBody.append("</OriginalInfo>");
                sbBody.append("<InqPay>");
                sbBody.append("<TotalRecord>");
                sbBody.append("<TotalNumber>").append(paymentInfos.length).append("</TotalNumber>");
                sbBody.append("<Sum>").append("{0}").append("</Sum>");
                sbBody.append("</TotalRecord>");
                if (paymentInfos.length > 0) {
                    String listCode = "";
                    for (int i = 0; i < paymentInfos.length; ++i) {
                        sbBody.append("<QueryPayDetails>");
                        listCode = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[i], (String)"ListCode");
                        sbBody.append("<OriginalListCode>").append(listCode).append("</OriginalListCode>");
                        sbBody.append("</QueryPayDetails>");
                        amount = amount.add(paymentInfos[i].getAmount());
                    }
                }
                sbBody.append("</InqPay>");
                sbBody.append("</Document>");
            }
        }
        catch (Exception e) {
            this.logger.info("\u5c01\u88c5\u67e5\u8be2\u652f\u4ed8\u62a5\u6587\u5931\u8d25\uff1a", (Object)e);
        }
        return MessageFormat.format(sbBody.toString(), amount.toPlainString());
    }
}

