/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.dc.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.dc.utils.GzipUtil;
import kd.ebg.aqap.banks.gxnx.dc.utils.Tcommon;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.crypto.DigestUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GxnxPacker {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(GxnxPacker.class);

    public static String packBalance(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1001S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element reqBody = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)reqBody, (String)"AcctNo", (String)accNo);
        String reqData = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return Tcommon.createCommonMsg(reqData);
    }

    private static Element packReqHead(String transCode, String seqId) {
        Element head = new Element("REQHEAD");
        JDomUtils.addChild((Element)head, (String)"TranCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"UserID"));
        JDomUtils.addChild((Element)head, (String)"ErpNo", (String)RequestContextUtils.getBankParameterValue((String)"ErpNo"));
        if (StringUtils.isEmpty((String)seqId)) {
            JDomUtils.addChild((Element)head, (String)"TranSeq", (String)GxnxPacker.getTranSeq(transCode));
        } else {
            JDomUtils.addChild((Element)head, (String)"TranSeq", (String)seqId);
        }
        JDomUtils.addChild((Element)head, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)head, (String)"TranTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"ChannelID", (String)"B2");
        return head;
    }

    private static String getTranSeq(String transCode) {
        String dateStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String ErpNo = RequestContextUtils.getBankParameterValue((String)"ErpNo");
        String tranCode = transCode.substring(0, 4);
        StringBuilder sb = new StringBuilder();
        sb.append(dateStr).append(ErpNo).append(tranCode).append(Sequence.gen8Sequence());
        return sb.toString();
    }

    private static Element packRoot() {
        return JDomUtils.createRoot((String)"GXNXYQ");
    }

    public static String packTodayDetail(BankDetailRequest request, String pageTag) {
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1003S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        String accNo = request.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"QryNo", (String)"10");
        logger.info("\u8d26\u53f7:" + request.getAcnt().getAccNo());
        logger.info("\u67e5\u8be2\u7684\u8d77\u59cb\u7b14\u6570:" + pageTag);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packHisDetail(BankDetailRequest request, String pageTag) {
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1004S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        String accNo = request.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"QryNo", (String)"10");
        logger.info("\u8d26\u53f7:" + request.getAcnt().getAccNo());
        logger.info("\u67e5\u8be2\u7684\u8d77\u59cb\u7b14\u6570:" + pageTag);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packSameBankPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e7f\u897f\u519c\u4fe12001S\u540c\u884c\u8f6c\u8d26\u63a5\u53e3\u53ea\u652f\u6301\u5355\u7b14", (String)"GxnxPacker_0", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        paymentInfo.setRequestSeq(GxnxPacker.getTranSeq("2001S"));
        Element reqHead = GxnxPacker.packReqHead("2001S", paymentInfo.getRequestSeq());
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"PayAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"PayAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"RecAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"RecAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"TranCcy", (String)paymentInfo.getIsoCurrencyCode());
        JDomUtils.addChild((Element)body, (String)"TranAmt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"Useage", (String)paymentInfo.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packQuerySameBankPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1005S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"OriTranSeq", (String)((PaymentInfo)paymentInfos.get(0)).getRequestSeq());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packDiffBankPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e7f\u897f\u519c\u4fe12002S\u8de8\u884c\u8f6c\u8d26\u63a5\u53e3\u53ea\u652f\u6301\u5355\u7b14", (String)"GxnxPacker_1", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        paymentInfo.setRequestSeq(GxnxPacker.getTranSeq("2002S"));
        Element reqHead = GxnxPacker.packReqHead("2002S", paymentInfo.getRequestSeq());
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        String payerAccName = paymentInfo.getAccName();
        String payerAccNo = paymentInfo.getAccNo();
        String unionDeptId = paymentInfo.getIncomeCnaps();
        String payeeBankName = paymentInfo.getIncomeBankName();
        String payeeAcName = paymentInfo.getIncomeAccName();
        String payeeAcNo = paymentInfo.getIncomeAccNo();
        String currency = paymentInfo.getIsoCurrencyCode();
        String amount = paymentInfo.getAmount().toString();
        JDomUtils.addChild((Element)body, (String)"PayAcctName", (String)payerAccName);
        JDomUtils.addChild((Element)body, (String)"PayAcctNo", (String)payerAccNo);
        JDomUtils.addChild((Element)body, (String)"RecBankNo", (String)unionDeptId);
        JDomUtils.addChild((Element)body, (String)"RecBankName", (String)payeeBankName);
        JDomUtils.addChild((Element)body, (String)"RecAcctName", (String)payeeAcName);
        JDomUtils.addChild((Element)body, (String)"RecAcctNo", (String)payeeAcNo);
        JDomUtils.addChild((Element)body, (String)"TranCcy", (String)currency);
        JDomUtils.addChild((Element)body, (String)"TranAmt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"Useage", (String)paymentInfo.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packQueryDiffBankPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1006S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"OriTranSeq", (String)((PaymentInfo)paymentInfos.get(0)).getRequestSeq());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packSalaryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        StringBuilder sb = new StringBuilder();
        String batchDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String fileName = sb.append("DF").append("_").append(batchDate).append("_").append(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()).append(".REQ").toString();
        StringBuilder fileContent = new StringBuilder();
        StringBuilder dataContent = new StringBuilder();
        BigDecimal actualTotalAmount = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            String seqId = ((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId();
            String accNo = ((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo();
            String accName = ((PaymentInfo)paymentInfos.get(i)).getIncomeAccName();
            String amt = ((PaymentInfo)paymentInfos.get(i)).getAmount().toString();
            String userNo = "";
            String cardType = "";
            String cardNo = "";
            dataContent.append(seqId).append('|').append(userNo).append('|').append(accNo).append('|').append(accName).append('|').append(cardType).append('|').append(cardNo).append('|').append(amt).append('|').append('\n');
            actualTotalAmount = actualTotalAmount.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
        }
        String dc = dataContent.toString();
        fileContent = fileContent.append(paymentInfos.size()).append("|").append(actualTotalAmount.toString()).append("|").append("\n").append(dc);
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("3003S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"BatchDate", (String)batchDate);
        JDomUtils.addChild((Element)body, (String)"BatchNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"HZAcctNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"FileName", (String)fileName);
        String fileCont = GzipUtil.gzipAndEncoder(fileContent.toString()).replaceAll("[\\t\\n\\r]", "");
        JDomUtils.addChild((Element)body, (String)"FileCont", (String)fileCont);
        JDomUtils.addChild((Element)body, (String)"Count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"Amt", (String)actualTotalAmount.toString());
        String md5 = DigestUtil.md5Hex((String)fileContent.toString(), (String)RequestContextUtils.getCharset()).toUpperCase(Locale.ENGLISH);
        JDomUtils.addChild((Element)body, (String)"MD5", (String)md5);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packQuerySalaryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("3004S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"BatchDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"BatchNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }
}

