/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.services.payment.batch;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.services.payment.batch.BatchQueryPayImpl;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbPacker;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public boolean match(PaymentInfo paymentInfo) {
        boolean flag = "pay".equals(paymentInfo.getSubBizType()) || "pay_for_salary".equals(paymentInfo.getSubBizType());
        flag = flag && !UseConvertor.isSalary((PaymentInfo)paymentInfo) && paymentInfo.is2Merge();
        return flag;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        return YnhtbPacker.packBatchPay(request);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return YnhtbParser.parseBatchPay(request, responseStr);
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "510003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u5f55\u5165", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

