/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        String yestodayBal;
        String availableBal;
        String rspStr = "";
        try {
            SdkInit.init();
            ApiHeader header = new ApiHeader();
            header.setMsgtype("yqwfw_qryAccBalance");
            header.setTraceno(Sequence.genSequence());
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("accNo", request.getAcnt().getAccNo());
            this.logger.info("\u6d59\u5546sdk\u4f59\u989d\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)header.getTraceno());
            ApiRspData data = ServiceBean.getService().invoke(header, body);
            rspStr = JSON.toJSONString((Object)data);
            this.logger.info("\u6d59\u5546\u4f59\u989d\u8bf7\u6c42\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        }
        catch (SdkException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6d59\u5546sdk\u5f02\u5e38\uff1a%1$s %2$s\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), e.getErrorCode(), e.getErrorParams()), (Throwable)e);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 , \u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        JSONObject jsonBody = root.getJSONObject("body");
        String bal = jsonBody.getString("bal");
        if (!StringUtils.isEmpty((String)bal)) {
            balanceInfo.setCurrentBalance(new BigDecimal(bal));
        }
        if (!StringUtils.isEmpty((String)(availableBal = jsonBody.getString("availableBal")))) {
            balanceInfo.setAvailableBalance(new BigDecimal(availableBal));
        }
        if (!StringUtils.isEmpty((String)(yestodayBal = jsonBody.getString("yestodayBal")))) {
            balanceInfo.setLastDayAvlBalance(new BigDecimal(yestodayBal));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

