/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import com.czb.sap.sdk.inf.DownloadFileIn;
import com.czb.sap.sdk.inf.DownloadFileOut;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.processDetail(request);
    }

    private EBBankDetailResponse processDetail(BankDetailRequest request) {
        SdkInit.init();
        ApiHeader header = new ApiHeader();
        header.setMsgtype("yqwfw_qryAccountingDetails");
        header.setTraceno(Sequence.genSequence());
        HashMap<String, String> body = new HashMap<String, String>(5);
        body.put("startDate", request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("endDate", request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("accNo", request.getAcnt().getAccNo());
        this.logger.info("\u6d59\u5546sdk\u660e\u7ec6\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)header.getTraceno());
        this.logger.info("\u6d59\u5546sdk\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570:{}", body);
        String rsp = "";
        try {
            ApiRspData data = ServiceBean.getService().invoke(header, body);
            rsp = JSON.toJSONString((Object)data);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        this.logger.info("\u6d59\u5546\u660e\u7ec6\u8bf7\u6c42\u8fd4\u56de\u62a5\u6587\uff1a" + rsp);
        return this.parse(request, rsp);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.processDetail(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if ("10011".equalsIgnoreCase(statusCode)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"DetailImpl_7", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        String field = jsonBody.getString("detailFileName");
        if (StringUtils.isEmpty((String)field)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u52a1\u660e\u7ec6\u6587\u4ef6\u6807\u8bc6\u4e3a\u7a7a   ", (String)"DetailImpl_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        }
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(10);
        InputStreamReader in = null;
        BufferedReader bufr = null;
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            String name;
            File file;
            Thread.sleep(DetailImpl.getWaiting4DataTime());
            DownloadFileIn downFile = new DownloadFileIn();
            downFile.setTraceno(Sequence.genSequence());
            downFile.setFileid(field);
            DownloadFileOut downOut = ServiceBean.getService().downloadFile(downFile);
            this.logger.info("\u6587\u4ef6\u5185\u5bb9\uff1a" + new String(downOut.getBody(), "UTF-8"));
            String storageRootPath = System.getProperty("user.dir");
            String savePath = storageRootPath + File.separator + "zsb_opa" + File.separator + EBContext.getContext().getCustomID();
            File filePath = FileCommonUtils.getFileByPath((String)savePath);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            if (!(file = FileCommonUtils.getFileByPath((String)(name = filePath + File.separator + Sequence.genSequence()))).exists()) {
                boolean newFile = file.createNewFile();
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\uff1a{}", (Object)newFile);
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                String str;
                fos.write(downOut.getBody(), 0, downOut.getBody().length);
                BankAcnt acnt = bankDetailRequest.getAcnt();
                in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                bufr = new BufferedReader(in);
                while ((str = bufr.readLine()) != null) {
                    String[] strs = str.split(",");
                    if (strs.length <= 10) continue;
                    DetailInfo info = new DetailInfo();
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    info.setCurrency(strs[8].replaceAll("\"", ""));
                    info.setBalance(new BigDecimal(strs[2].replaceAll("\"", "")));
                    info.setOppAccNo(strs[3].replaceAll("\"", ""));
                    info.setOppAccName(strs[4].replaceAll("\"", ""));
                    info.setOppBankName(strs[6].replaceAll("\"", ""));
                    String flag = strs[7].replaceAll("\"", "");
                    BigDecimal amt = new BigDecimal(strs[9].replaceAll("\"", ""));
                    if ("1".equals(flag)) {
                        info.setDebitAmount(amt);
                        info.setCreditAmount(BigDecimal.ZERO);
                    } else {
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(amt);
                    }
                    String date = strs[11].replaceAll("\"", "");
                    String time = strs[12].replaceAll("\"", "");
                    try {
                        if (StringUtils.isEmpty((String)date) || StringUtils.isEmpty((String)time)) {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65f6\u95f4\u4e3a\u7a7a.", (String)"DetailImpl_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
                        }
                        info.setTransDate(LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                        info.setTransTime(LocalDateTime.parse(date + time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%1$s\u3002", (String)"DetailImpl_8", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                    }
                    JSONObject jsonObject = new JSONObject();
                    String serialNo = strs[10].replaceAll("\"", "");
                    jsonObject.put("transDate", (Object)date);
                    jsonObject.put("serialNo", (Object)serialNo);
                    jsonObject.put("cdFlag", (Object)strs[7].replaceAll("\"", ""));
                    jsonObject.put("amount", (Object)strs[9].replaceAll("\"", ""));
                    String jsonStr = jsonObject.toJSONString();
                    info.setJsonMap(jsonStr);
                    info.setBankDetailNo(serialNo);
                    String transDateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonStr);
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    info.setReceiptNo(receiptNo);
                    String explanation = strs[14].replaceAll("\"", "");
                    if (StringUtils.isNotEmpty((String)explanation) && explanation.indexOf("_KD_") != -1) {
                        String id = BizNoUtil.getId((String)explanation);
                        String msg = BizNoUtil.getMsg((String)explanation);
                        info.setPayBankDetailSeqID(id);
                        info.setExplanation(msg);
                    } else {
                        info.setExplanation(explanation);
                    }
                    list.add(info);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                if (bufr != null) {
                    bufr.close();
                }
            }
            catch (IOException downFile) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException downFile) {}
        }
        return new EBBankDetailResponse(list);
    }

    private static long getWaiting4DataTime() {
        String value = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.waiting4Data);
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 500L;
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "yqwfw_qryAccountingDetails";
    }

    public String getBizDesc() {
        return null;
    }
}

