/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nyb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nyb.dc.service.util.Packer;
import kd.ebg.aqap.banks.nyb.dc.service.util.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead(Sequence.gen18Sequence(), "DEAL0006");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"accountCode", (String)accNo);
        JDomUtils.addChild((Element)entity, (String)"acct_seqno", (String)"0");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element record = JDomUtils.getChildElement((Element)body, (String)"entity");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankCurrency(record.getChildText("currencyCode"));
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, record.getChildText("remainMoney"));
        this.setAvailableBalance(balanceInfo, record.getChildText("usableMoney"));
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DEAL0006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        try {
            String requestStr = this.pack(request);
            String responseStr = Packer.getMessage(requestStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), e.getMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

