/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nyb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nyb.dc.service.util.Packer;
import kd.ebg.aqap.banks.nyb.dc.service.util.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.process(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead(Sequence.gen18Sequence(), "DEAL0008");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"accountCode", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"pageCount", (String)"10");
        JDomUtils.addChild((Element)body, (String)"pageNo", (String)this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%2$s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element body = root.getChild("body");
        Element list = body.getChild("list");
        List records = list.getChildren("entity");
        if (records.size() == 0) {
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            this.setLastPage(true);
            return detailResponse;
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < records.size(); ++i) {
            Element dto = (Element)records.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(request.getBankCurrency());
            detail.setOppAccNo(dto.getChildTextTrim("otherAccount"));
            detail.setOppAccName(dto.getChildTextTrim("otherName"));
            detail.setAccName(request.getAcnt().getAccName());
            detail.setAccNo(request.getAcnt().getAccNo());
            String transferDate = dto.getChildTextTrim("tradeTime");
            LocalDateTime transTime = LocalDateTime.parse(transferDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            detail.setTransDate(transTime.toLocalDate());
            detail.setTransTime(transTime);
            BigDecimal amount = new BigDecimal(dto.getChildTextTrim("tradeMoney"));
            String CDFlag = dto.getChildTextTrim("tradeSign");
            if (CDFlag.equalsIgnoreCase("0")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(amount);
            }
            detail.setExplanation(dto.getChildTextTrim("tradeSummary"));
            detail.setBalance(new BigDecimal(dto.getChildTextTrim("remainMoney")));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(dto);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(dto.getChildTextTrim("detailCode"));
            totalList.add(detail);
        }
        if (records.size() < 10) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DEAL0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse process(BankDetailRequest request) {
        try {
            String requestStr = this.pack(request);
            String responseStr = Packer.getMessage(requestStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), e.getMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

