/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nyb.dc.service.payment.single;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nyb.dc.service.util.Packer;
import kd.ebg.aqap.banks.nyb.dc.service.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBankQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final Logger logger = LoggerFactory.getLogger(SingleBankQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DEAL0011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u7b14\u652f\u4ed8\u7ed3\u679c", (String)"SingleBankQueryPayImpl_0", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = Packer.buildHead(paymentInfos[0].getBankDetailSeqId(), "DEAL0010");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"billCode", (String)paymentInfos[0].getBankRefID());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        logger.info("\u72b6\u6001:" + bankResponse.getResponseCode());
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = resBody.getChild("entity");
        String retCode = entity.getChildText("retCode");
        if ("000000".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SingleBankQueryPayImpl_2", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), (String)retCode, (String)bankResponse.getResponseMessage());
        } else if ("000001".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SingleBankQueryPayImpl_3", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), (String)retCode, (String)bankResponse.getResponseMessage());
        } else if ("000002".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SingleBankQueryPayImpl_4", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), (String)retCode, (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SingleBankQueryPayImpl_1", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), (String)retCode, (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            String requestStr = this.pack(request);
            String responseStr = Packer.getMessage(requestStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u901a\u4e0d\u4ed8\u6b3e\u7ed3\u679c\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"SingleBankQueryPayImpl_5", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), e.getMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

