/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nyb.dc.service.util;

import com.caucho.hessian.client.HessianProxyFactory;
import java.net.MalformedURLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nyb.dc.service.util.DealService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static Element buildHead(String seqNo, String transCode) {
        Element root = new Element("request");
        Element head = JDomUtils.addChild((Element)root, (String)"header");
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:SS")));
        JDomUtils.addChild((Element)head, (String)"tradeCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"serialId", (String)seqNo);
        JDomUtils.addChild((Element)root, (String)"body");
        return root;
    }

    public static String getURL() {
        IParameter parameter = EBContext.getContext().getParameter();
        String ip = parameter.getBankParameter("ip");
        String exchangePort = parameter.getBankParameter("exchangePort");
        String exchangeProtocol = parameter.getBankParameter("exchangeProtocol");
        String url = RequestContextUtils.getBankParameterValue((String)"URL");
        return exchangeProtocol + "://" + ip + ":" + exchangePort + url;
    }

    public static String getMessage(String content) {
        String url = Packer.getURL();
        DealService basic = null;
        HessianProxyFactory factory = new HessianProxyFactory();
        IParameter parameter = EBContext.getContext().getParameter();
        String timeOut = parameter.getBankParameter("timeout");
        factory.setReadTimeout((long)(Integer.parseInt(timeOut) * 60 * 1000));
        try {
            basic = (DealService)factory.create(DealService.class, url);
            String responseStr = basic.transfer(content);
            return responseStr;
        }
        catch (MalformedURLException e) {
            String errorMsg = ResManager.loadKDString((String)"\u4ea4\u4e92\u5f02\u5e38", (String)"Packer_0", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u5f02\u5e38:%s\u3002", (String)"Packer_1", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

