/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.dc.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.SecurityUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ebank-customer/accountOverview/queryAccBaseInfo.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        String jsonString = Packer.packBalance(bankBalanceRequest).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject balance = new JSONObject();
        balance.put("signData", (Object)sign);
        balance.put("ciphertext", (Object)encry);
        balance.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        return balance.toJSONString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        JSONObject response = JSONObject.parseObject((String)s);
        String sys_code = response.getString("sys_code");
        String sys_msg = response.getString("sys_msg");
        if (!"0".equalsIgnoreCase(sys_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), sys_code, sys_msg));
        }
        String data = response.getString("data");
        String decry = SecurityUtil.getInstance().getDecry(data);
        JSONObject balanceJson = JSONObject.parseObject((String)decry);
        String ec = balanceJson.getString("ec");
        String em = balanceJson.getString("em");
        if (!"0".equalsIgnoreCase(ec)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), ec, em));
        }
        JSONObject balanceData = balanceJson.getJSONObject("data");
        String currencyType = balanceData.getString("currencyType");
        String balance = balanceData.getString("balance");
        String balanceAvailable = balanceData.getString("balanceAvailable");
        BalanceInfo info = new BalanceInfo();
        info.setBankCurrency(currencyType);
        info.setBankAcnt(bankBalanceRequest.getAcnt());
        this.setCurrentBalance(info, balance);
        this.setAvailableBalance(info, balanceAvailable);
        this.setBalanceDateTime(info, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

