/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jnb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jnb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.jnb.dc.Constants;
import kd.ebg.aqap.banks.jnb.dc.service.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TransCode", (String)"B2EActTrsQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(Packer.DATE_TIME_SEPARATION_FORMATTER));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element map = JDomUtils.addChild((Element)list, (String)"Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)request.getStartDate().format(Packer.DATE_SEPARATION_FORMATTER));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)request.getEndDate().format(Packer.DATE_SEPARATION_FORMATTER));
        JDomUtils.addChild((Element)map, (String)"currentIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)map, (String)"pageSize", (String)"16");
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        String acNo = head.getChildTextTrim("AcNo");
        if (!"000000".equals(iBSReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg})));
        }
        if (!request.getAcnt().getAccNo().equals(acNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg})));
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list) {
            return new EBBankDetailResponse(detailList);
        }
        List maps = list.getChildren();
        if (null == maps || maps.size() < 1) {
            return new EBBankDetailResponse(detailList);
        }
        String rowcnt = body.getChildTextTrim("rowcnt");
        if (rowcnt.matches("\\d+")) {
            int curPage;
            int cnt = Integer.parseInt(rowcnt);
            this.setLastPage(cnt <= (curPage = Integer.parseInt(this.getCurrentPage())) + Constants.PAGE_SIZE_N);
            this.setCurrentPage(curPage + Constants.PAGE_SIZE_N);
        }
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String transDate = map.getChildTextTrim("TransDate");
            String transTime = map.getChildTextTrim("TransTime");
            String amount = map.getChildTextTrim("Amount");
            String currency = map.getChildTextTrim("Currency");
            String dCFlag = map.getChildTextTrim("DCFlag");
            String balance = map.getChildTextTrim("Balance");
            String remark = map.getChildTextTrim("Remark");
            String Toacct = map.getChildTextTrim("Toacct");
            String Toacna = map.getChildTextTrim("Toacna");
            if (StringUtils.isEmpty((String)amount)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a,Amount=", (String)"DetailImpl_1", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), amount));
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acNo);
            detail.setCurrency(currency);
            if ("C".equals(dCFlag)) {
                detail.setDebitAmount(BigDecimal.ZERO);
                detail.setCreditAmount(new BigDecimal(amount));
            } else {
                detail.setDebitAmount(new BigDecimal(amount));
                detail.setCreditAmount(BigDecimal.ZERO);
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            detail.setOppBankName("");
            detail.setOppAccNo(Toacct);
            detail.setOppAccName(Toacna);
            detail.setExplanation(remark);
            if (StringUtils.isEmpty((String)transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f<TransDate>\u4e3a\u7a7a\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u5904\u7406\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)transTime)) {
                if (BankBusinessConfig.isWithPoint()) {
                    detail.setTransTime(LocalDateTime.parse(transDate + "00.00.00", Packer.DATE_TIME_POINT_FORMATTER));
                } else {
                    detail.setTransTime(LocalDateTime.parse(transDate + "000000000", Packer.DATE_TIME_NO_POINT_FORMATTER));
                }
            } else if (BankBusinessConfig.isWithPoint()) {
                detail.setTransTime(LocalDateTime.parse(transDate + transTime, Packer.DATE_TIME_POINT_FORMATTER));
            } else {
                detail.setTransTime(LocalDateTime.parse(transDate + transTime, Packer.DATE_TIME_NO_POINT_FORMATTER));
            }
            detail.setTransDate(detail.getTransTime().toLocalDate());
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

