/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cmbc.openbank.api.utils.SignVerifyTenantUtil;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcRequest;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.utils.CMBCCertificateUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class CmbcPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CmbcPacker.class);
    private static final String VERSION = "V1.0";
    private static final String ENCRYPT_TYPE = "SM2";
    private static final String FORMAT = "json";
    private static final String CUSTOMER_NO = "";
    private static AtomicInteger num = new AtomicInteger(0);

    private CmbcPacker() {
    }

    public static String prepareParams(CmbcRequest cmbcRequest) {
        return CmbcPacker.prepareParams(cmbcRequest, null);
    }

    public static String prepareParams(CmbcRequest cmbcRequest, BankApplyRequest request) {
        ArrayList<String> commonParam = new ArrayList<String>();
        Map<String, Object> busiParamMap = cmbcRequest.getBusiParamMap();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String reqID = CmbcPacker.reqUUID();
        String appId = BankBusinessConfig.getCmbcAppId();
        paramMap.put("request_id", reqID);
        paramMap.put("app_id", appId);
        paramMap.put("method", cmbcRequest.getMethod());
        paramMap.put("version", VERSION);
        paramMap.put("encrypt_type", ENCRYPT_TYPE);
        paramMap.put("format", FORMAT);
        paramMap.put("auth_token", CUSTOMER_NO);
        paramMap.put("cust_id", CUSTOMER_NO);
        paramMap.put("cust_sign", CUSTOMER_NO);
        paramMap.put("notify_url", CUSTOMER_NO);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String time = dateFormat.format(new Date(timestamp));
        paramMap.put("timestamp", time);
        commonParam.add(reqID);
        commonParam.add(appId);
        commonParam.add(cmbcRequest.getMethod());
        commonParam.add(VERSION);
        commonParam.add(ENCRYPT_TYPE);
        commonParam.add(FORMAT);
        commonParam.add(CUSTOMER_NO);
        commonParam.add(CUSTOMER_NO);
        commonParam.add(CUSTOMER_NO);
        commonParam.add(CUSTOMER_NO);
        commonParam.add(time);
        if (busiParamMap != null) {
            String reqSeq = Sequence.gen18Sequence();
            if (!"settlement.transfer.ent_single_order".equalsIgnoreCase(cmbcRequest.getMethod())) {
                busiParamMap.put("req_seq", reqSeq);
            }
            if (request != null) {
                request.getHeader().setExtData(reqSeq);
            }
        }
        String busiParamStr = JSON.toJSONString(busiParamMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
        StringBuilder str = new StringBuilder(busiParamStr);
        for (Object e : commonParam) {
            str.append("|");
            if (null == e) continue;
            String value = null;
            if (e instanceof String) {
                value = (String)e;
            } else if (e instanceof Map) {
                value = JSON.toJSONString(e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
            }
            str.append(value);
        }
        String cmbcPublicKey = CMBCCertificateUtil.getPublicFileDir();
        CertInfo certInfo = CMBCCertificateUtil.getPrivateCertInfo();
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u4f20\u4e86\u79c1\u94a5\u6587\u4ef6", (String)"CmbcPacker_0", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
        }
        String privateKeyPwd = certInfo.getCertPassword();
        String privateKey = CMBCCertificateUtil.getPrivateFileDir((CertInfo)certInfo);
        logger.info("\u6c11\u751f\u94f6\u884csignOld\uff1a{}", (Object)str.toString());
        String signedStr = SignVerifyTenantUtil.p7DetachMsgSignA((String)str.toString(), (String)privateKey, (String)privateKeyPwd, (String)cmbcPublicKey);
        logger.info("\u6c11\u751f\u94f6\u884csignNew\uff1a{}", (Object)signedStr);
        logger.info("\u6c11\u751f\u94f6\u884cbusi_paramOld\uff1a{}", (Object)busiParamStr);
        busiParamStr = SignVerifyTenantUtil.envelopeEncryptMessage((String)busiParamStr, (String)CUSTOMER_NO, (String)privateKey, (String)privateKeyPwd, (String)cmbcPublicKey);
        logger.info("\u6c11\u751f\u94f6\u884cbusi_paramNew\uff1a{}", (Object)busiParamStr);
        paramMap.put("sign", signedStr);
        paramMap.put("busi_param", busiParamStr);
        return JSON.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
    }

    private static String reqUUID() {
        String jvmId = "44";
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateDay = sdf.format(date);
        SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmssSSS");
        String dateTime = sdf2.format(date);
        SecureRandom random = new SecureRandom();
        StringBuilder sbRandom = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sbRandom.append(random.nextInt(10));
        }
        String uuid = "T77" + jvmId + dateDay + sbRandom + dateTime + CmbcPacker.count();
        return uuid.replace("-", CUSTOMER_NO);
    }

    private static String count() {
        int result = num.incrementAndGet();
        num.compareAndSet(400000, 0);
        return String.format("%06d", result);
    }
}

