/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szsrcb.cmp.services.payment.samebank;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Common;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Packer;
import kd.ebg.aqap.banks.szsrcb.cmp.services.payment.QueryPay;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TransferSameBankImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPay.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String tr_code = "03020104B0210";
        Element ap = Packer.createCommonHead(tr_code, paymentInfos[0].getBankBatchSeqId(), "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"payAcctNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAcctName", (String)paymentInfos[0].getAccName());
        String amount = paymentInfos[0].getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"rcvAcctNo", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcvAcctName", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        String exp = StringUtils.isEmpty((String)paymentInfos[0].getExplanation()) ? ResManager.loadKDString((String)"\u94f6\u4f01\u4ed8\u6b3e", (String)"TransferSameBankImpl_0", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]) : paymentInfos[0].getExplanation();
        JDomUtils.addChild((Element)body, (String)"summary", (String)exp);
        JDomUtils.addChild((Element)body, (String)"postscript", (String)exp);
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"TransferSameBankImpl_1", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"TransferSameBankImpl_2", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020104B0210";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u4ed8\u6b3e", (String)"TransferSameBankImpl_3", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

