/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.payment.salary;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.banks.xib.dc.service.payment.salary.QueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        JsonObject body = new JsonObject();
        String batchNo = "";
        String debitAcctNo = "";
        JsonArray transList = new JsonArray();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < paymentInfos.length; ++i) {
            JsonObject transDetail = new JsonObject();
            if (i == 0) {
                batchNo = paymentInfos[i].getBankBatchSeqId();
                debitAcctNo = paymentInfos[i].getAccNo();
                body.addProperty("batchNo", batchNo);
                body.addProperty("debitAcctNo", debitAcctNo);
                body.addProperty("debitAcctName", paymentInfos[i].getAccName());
            } else if (!batchNo.equalsIgnoreCase(paymentInfos[i].getBankBatchSeqId()) || !debitAcctNo.equalsIgnoreCase(paymentInfos[i].getAccNo())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u5de5\u8d44\u652f\u4ed8\u7684\u6279\u6b21ID\u548c\u4ed8\u6b3e\u8d26\u6237\u4e0d\u4e00\u81f4\u3002", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]));
            }
            transDetail.addProperty("transId", paymentInfos[i].getId());
            transDetail.addProperty("creditAcctNo", paymentInfos[i].getIncomeAccNo());
            transDetail.addProperty("creditAcctName", paymentInfos[i].getIncomeAccName());
            if (paymentInfos[i].getAmount() != null) {
                totalAmount = totalAmount.add(paymentInfos[i].getAmount());
            }
            transDetail.addProperty("amount", paymentInfos[i].getAmount() + "");
            transDetail.addProperty("currency", "CNY");
            transList.add((JsonElement)transDetail);
        }
        body.addProperty("totalNumber", (Number)transList.size());
        body.addProperty("totalAmount", (Number)totalAmount);
        body.add("transList", (JsonElement)transList);
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109010", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = XMB_Parser.paseHeadRoot(s);
        String responseCode = rsp.getResponseCode();
        String responseMessage = rsp.getResponseMessage();
        if ("00000".equalsIgnoreCase(responseCode) || "000000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)responseCode, (String)responseMessage);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)responseCode, (String)responseMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "HSQ";
    }

    public String getBizCode() {
        return "IESI109010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4ea4\u6613\u6307\u4ee4\u63d0\u4ea4\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryImpl.class;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

