/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.balance.HisBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        List acnts = bankBalanceRequest.getBankAcntList();
        if ("GetAccInfo".equals(BankBusinessConfig.balanceChoose())) {
            Element root = CMB_DC_Packer.packRoot("GetAccInfo");
            for (BankAcnt acnt : acnts) {
                String branchNo = CMBStore.getInstance().getAreaCode(acnt);
                Element sdkacinfx = JDomUtils.addChild((Element)root, (String)"SDKACINFX");
                JDomUtils.addChild((Element)sdkacinfx, (String)"BBKNBR", (String)branchNo);
                JDomUtils.addChild((Element)sdkacinfx, (String)"ACCNBR", (String)acnt.getAccNo());
            }
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        Element root = CMB_DC_Packer.packRoot("NTQADINF");
        for (BankAcnt acnt : acnts) {
            String branchNo = CMBStore.getInstance().getAreaCode(acnt);
            Element sdkacinfx = JDomUtils.addChild((Element)root, (String)"NTQADINFX");
            JDomUtils.addChild((Element)sdkacinfx, (String)"BBKNBR", (String)branchNo);
            JDomUtils.addChild((Element)sdkacinfx, (String)"ACCNBR", (String)acnt.getAccNo());
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equals(headRsp.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        List list = "GetAccInfo".equals(BankBusinessConfig.balanceChoose()) ? root.getChildren("NTQACINFZ") : root.getChildren("NTQADINFZ");
        if (null == list || list.size() == 0) {
            return new EBBankBalanceResponse();
        }
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element ntqacinfz = (Element)list.get(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            infos.add(balanceInfo);
            String accNo = ntqacinfz.getChildTextTrim("ACCNBR");
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accNo);
            String ERRCOD = ntqacinfz.getChildTextTrim("ERRCOD");
            if ("SUC0000".equals(ERRCOD) || "GetAccInfo".equals(BankBusinessConfig.balanceChoose())) {
                String balance = ntqacinfz.getChildTextTrim("ONLBLV");
                String usableBalance = ntqacinfz.getChildTextTrim("AVLBLV");
                String currType = ntqacinfz.getChildTextTrim("CCYNBR");
                String accBalance = ntqacinfz.getChildTextTrim("ACCBLV");
                String intcod = ntqacinfz.getChildTextTrim("INTCOD");
                if (!StringUtils.isEmpty((String)intcod) && "S".equals(intcod) && BankBusinessConfig.isChooseACCBLV()) {
                    this.setAvailableBalance(balanceInfo, accBalance);
                    this.setCurrentBalance(balanceInfo, accBalance);
                } else {
                    this.setAvailableBalance(balanceInfo, usableBalance);
                    this.setCurrentBalance(balanceInfo, balance);
                    this.setLastDayAvlBalance(balanceInfo, accBalance);
                }
                if ("GetAccInfo".equals(BankBusinessConfig.balanceChoose()) && "S".equals(intcod) && !BankBusinessConfig.lastDayBalIsAccblv()) {
                    logger.info("\u6628\u65e5\u4f59\u989d\u53d6\u503c\u914d\u7f6e\u4e3aBALAMT\uff0c\u5f00\u59cb\u67e5\u8be2\u5386\u53f2\u4f59\u989d");
                    bankBalanceRequest.setStartDate(LocalDate.now().minusDays(1L));
                    bankBalanceRequest.setEndDate(LocalDate.now().minusDays(1L));
                    HisBalanceImpl hisBalance = new HisBalanceImpl();
                    EBBankBalanceResponse ebBankBalanceResponse = hisBalance.hisBalance(bankBalanceRequest);
                    BalanceInfo info = (BalanceInfo)ebBankBalanceResponse.getBalances().get(0);
                    BigDecimal lastDayAvlBalance = info.getCurrentBalance();
                    balanceInfo.setLastDayAvlBalance(lastDayAvlBalance);
                } else {
                    this.setLastDayAvlBalance(balanceInfo, accBalance);
                }
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currType);
                continue;
            }
            String ERRTXT = ntqacinfz.getChildTextTrim("ERRTXT");
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)ERRCOD, (String)ERRTXT));
        }
        return new EBBankBalanceResponse(infos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public int limit() {
        return 10;
    }
}

