/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.detail;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static Logger logger = LoggerFactory.getLogger(TodayDetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public boolean match(BankDetailRequest request) {
        return super.match(request);
    }

    public String pack(BankDetailRequest request) {
        String province;
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        String branchNo = acnt.getAreaCode();
        if (StringUtils.isEmpty((String)branchNo) && !StringUtils.isEmpty((String)(province = acnt.getProvince()))) {
            branchNo = CMBStore.getInstance().matchProvince(province).getBranchBankCode();
        }
        return CMB_DC_Packer.packDetail(accNo, branchNo, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        BankAcnt acnt = request.getHeader().getAcnt();
        EBBankDetailResponse response = new EBBankDetailResponse(CMB_DC_Parser.parseDetails(request, responseStr));
        return response;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GetTransInfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3\u67e5\u8be2\u8d26\u6237\u4ea4\u6613\u4fe1\u606f;\u4ea4\u6613\u7801\u662fGetTransInfo", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

