/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.constants.CMBReturnFlgState;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "NTQRYSTY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u4ed8\u6b3e\u67e5\u8be2", (String)"CommonQueryPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = CMB_DC_Packer.packRoot("NTSTLINF");
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element ntst = JDomUtils.addChild((Element)root, (String)"NTSTLINFX");
            JDomUtils.addChild((Element)ntst, (String)"REQNBR", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"REQNUBR"));
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CommonQueryPayImpl.parseBatchQueryPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public static void parseBatchQueryPay(List<PaymentInfo> paymentInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO(root);
        if ("0".equals(response.getResponseCode())) {
            List ntagplstz1 = root.getChildren("NTQPAYQYZ");
            if (null == ntagplstz1 || ntagplstz1.size() < 1) {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                return;
            }
            for (Element element : ntagplstz1) {
                String yurref = JDomUtils.getChildTextTrim((Element)element, (String)"YURREF");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)PaymentUtil.getSeqIdFromYurref(yurref));
                if (null == paymentInfo) continue;
                String reqsts = JDomUtils.getChildTextTrim((Element)element, (String)"REQSTS");
                String rtnflg = JDomUtils.getChildTextTrim((Element)element, (String)"RTNFLG");
                String message = JDomUtils.getChildTextTrim((Element)element, (String)"RTNNAR");
                String bankMessage = CMBReturnFlgState.flagMaps.get(rtnflg);
                if (!"FIN".equals(reqsts) || !"F".equals(rtnflg)) continue;
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)(StringUtils.isEmpty((String)message) ? bankMessage : message));
            }
        }
    }
}

