/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.SingleIndividualPayImpl;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseConvertor {
    private static Logger logger = LoggerFactory.getLogger(UseConvertor.class);

    public static String convert2CMBUseCn(PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCN();
        if ("-1".equalsIgnoreCase(useCode)) {
            String implClassName;
            String string = implClassName = UseConvertor.isSinglePay(paymentInfo) ? SingleIndividualPayImpl.class.getName() : IndividualPayImpl.class.getName();
            if (implClassName.equalsIgnoreCase(paymentInfo.getImplClassName())) {
                String customId = EBContext.getContext().getCustomID();
                String interfaceName = "AgentRequest";
                String bankVersion = "CMB_DC";
                useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
                return useCode;
            }
            logger.info("\u5f00\u53d1\u9519\u8bef\uff0c\u4e0d\u662f\u62db\u884c\u4ee3\u53d1\u4e1a\u52a1\uff0c\u4e0d\u9700\u8981\u8f6c\u6362\u4e3a\u62db\u884c\u4ee3\u53d1\u7684 \u4ea4\u6613\u4ee3\u7801\u540d\u79f0");
            return paymentInfo.getUseCN();
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%s", (String)"UseConvertor_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static String convert2CMBTRSTYP(String use) throws EBServiceException {
        String useCode = "BYBK";
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "NTAGCAPY";
        String bankVersion = "CMB_DC";
        String useCn = use;
        useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
        return useCode;
    }

    public static boolean isSalary(PaymentInfo paymentInfo) {
        if ("-1".equalsIgnoreCase(paymentInfo.getUseCode())) {
            return ResManager.loadKDString((String)"\u5de5\u8d44", (String)"UseConvertor_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]).equalsIgnoreCase(paymentInfo.getUseCN());
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%s", (String)"UseConvertor_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static boolean isTransfer(PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCN();
        if ("-1".equalsIgnoreCase(useCode)) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"UseConvertor_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn) || ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"UseConvertor_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%s", (String)"UseConvertor_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static boolean isTransUp(PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCN();
        if ("-1".equalsIgnoreCase(useCode)) {
            if (!UseConvertor.isTransfer(paymentInfo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u4e0d\u662f\u8d44\u91d1\u4e0a\u5212,\u4e5f\u4e0d\u662f\u8d44\u91d1\u4e0b\u62e8", (String)"UseConvertor_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
            }
            return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"UseConvertor_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%s", (String)"UseConvertor_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    private static boolean isSinglePay(PaymentInfo paymentInfo) {
        try {
            return paymentInfo.getMerge() == false || BankBusinessConfig.isSinglePay();
        }
        catch (Exception e) {
            logger.info(e.toString());
            return false;
        }
    }
}

