/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Payment";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5185\u90e8\u8f6c\u8d26;\u4ea4\u6613\u7801\u662fPayment,N02020:\u5185\u90e8\u8f6c\u5e10", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        String busmod = EBContext.getContext().getParameter().getBankParameter("BUSMOD4Allocation");
        if (StrUtil.isEmpty((String)busmod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d44\u91d1\u5212\u62e8\uff08\u5185\u90e8\u8f6c\u8d26\uff09\u7684'\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7'", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String dbtbbk = paymentInfo.getAreaCode();
        String encoding = EBContext.getContext().getCharsetName();
        Element root = CMB_DC_Packer.packRoot("Payment");
        Element sdkpayrqx = JDomUtils.addChild((Element)root, (String)"SDKPAYRQX");
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSCOD", (String)"N02020");
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSMOD", (String)busmod);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
        }
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element sdkpaydtx = JDomUtils.addChild((Element)root, (String)"SDKPAYDTX");
            JDomUtils.addChild((Element)sdkpaydtx, (String)"YURREF", (String)PaymentUtil.setBankDetailRefID((PaymentInfo)paymentInfos.get(i)));
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTACC", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTBBK", (String)dbtbbk);
            JDomUtils.addChild((Element)sdkpaydtx, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NUSAGE", (String)StringUtils.substringChinese((String)((PaymentInfo)paymentInfos.get(i)).getExplanation(), (String)encoding, (int)62));
            JDomUtils.addChild((Element)sdkpaydtx, (String)"BUSNAR", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTACC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTPVC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTBBK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAreaCode());
        }
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

