/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.utils.GLBParser;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    public EBBankPayResponse parseQueryPay(BankPayRequest request, String rspStr) throws EBServiceException {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = bank_root.getChild("Sys_Head");
        Element body = bank_root.getChild("Body");
        Element List2 = body.getChild("List");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("000000".equals(bankStatus) || "OK".equals(bankStatus)) {
            QueryPayParser.parsepayInfo(request, List2, headRsp);
        } else if ("FL".equals(bankStatus) || "F".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else if ("UC".equals(bankStatus) || "U".equals(bankStatus) || "UNRSLT".equals(bankStatus) || "ibserror.uncertain_trs_state".equals(bankStatus) || "SB".equals(bankStatus) || "BH".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private static void parsepayInfo(BankPayRequest request, Element root, BankResponse headRsp) throws EBServiceException {
        List rowinfos = root.getChildren("Row");
        List<PaymentInfo> paymentInfos = QueryPayParser.preBatchSameItemCheck(request);
        for (int i = 0; i < rowinfos.size(); ++i) {
            Element row = (Element)rowinfos.get(i);
            String accnbr = row.getChildTextTrim("PayeeAccountNo");
            String trsamt = row.getChildTextTrim("Amount");
            String stscod = row.getChildTextTrim("State");
            if (StringUtils.isEmpty((String)trsamt)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u91d1\u989dTRSAMT\u4e3a\u7a7a\u3002", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]));
            }
            BigDecimal amount = new BigDecimal(trsamt.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)accnbr, (BigDecimal)(amount = amount.setScale(2)));
            if (null == paymentInfo) continue;
            QueryPayParser.handlePayStatus(paymentInfo, stscod, headRsp.getResponseMessage());
        }
        QueryPayParser.processingBankItemDataHandler(rowinfos, headRsp.getResponseMessage());
        PayStatusMatchUtil.backBatchSameItemHandler((List)request.getPaymentInfos(), (boolean)false, (boolean)false, (boolean)false);
    }

    private static List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    private static void processingBankItemDataHandler(List<Element> elementList, String msg) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = QueryPayParser.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String stscod = JDomUtils.getChildText((Element)element, (String)"State");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    QueryPayParser.handlePayStatus(tempInfo, stscod, msg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private static PaymentInfo handlePayStatus(PaymentInfo tempInfo, String stscod, String msg) {
        if ("000000".equals(stscod) || "OK".equals(stscod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)stscod, (String)msg);
        } else if ("FL".equals(stscod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)stscod, (String)msg);
        } else if ("F".equals(stscod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)stscod, (String)msg);
        } else if ("UC".equals(stscod) || "U".equals(stscod) || "UNRSLT".equals(stscod) || "ibserror.uncertain_trs_state".equals(stscod) || "SB".equals(stscod) || "BH".equals(stscod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)stscod, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (String)stscod, (String)msg);
        }
        return tempInfo;
    }

    private static String getBankDataKey(Element element) {
        String incomeNo = element.getChildTextTrim("PayeeAccountNo");
        String incomeName = "";
        String amount = element.getChildTextTrim("Amount");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }
}

