/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.norinco.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NorincoParser {
    public static Element parseString2Root(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"GB18030");
        return root;
    }

    public static EBBankBalanceResponse parseBalance(String rspStr) {
        Element root = NorincoParser.parseString2Root(rspStr);
        Element responseNode = root.getChild("response");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        Element resultsetNode = responseNode.getChild("resultset");
        if (resultsetNode != null) {
            List resultNodes = resultsetNode.getChildren("result");
            if (resultNodes != null && !resultNodes.isEmpty()) {
                for (Object resultNodeObj : resultNodes) {
                    Element resultNode = (Element)resultNodeObj;
                    BalanceInfo balanceInfo = NorincoParser.handleBalanceResult(resultNode);
                    balanceInfos.add(balanceInfo);
                }
            }
        } else {
            Element resultNode = responseNode.getChild("result");
            BalanceInfo balanceInfo = NorincoParser.handleBalanceResult(resultNode);
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    private static BalanceInfo handleBalanceResult(Element resultNode) {
        BalanceInfo balanceInfo = new BalanceInfo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(resultNode.getChildText("AccountCode"));
        bankAcnt.setAccName(resultNode.getChildText("AccountName"));
        bankAcnt.setCurrency(resultNode.getChildText("CurrencyCode"));
        balanceInfo.setBankAcnt(bankAcnt);
        if (!"0".equals(resultNode.getChildTextTrim("retCode"))) {
            balanceInfo.setError(resultNode.getChildTextTrim("retCode"));
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25 :%s\u3002", (String)"NorincoParser_6", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{resultNode.getChildTextTrim("retCode"), resultNode.getChildTextTrim("errMsg")}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        balanceInfo.setBankCurrency(resultNode.getChildText("CurrencyCode"));
        balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildText("Balance")));
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildText("Balance")));
        return balanceInfo;
    }

    public static EBBankDetailResponse parseHisDetail(BankDetailRequest request, String rspStr) {
        Element root = NorincoParser.parseString2Root(rspStr);
        Element responseNode = root.getChild("response");
        String retCode = responseNode.getChild("result").getChildTextTrim("retCode");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        if ("0".equals(retCode)) {
            Element resultsetNode = responseNode.getChild("resultset");
            List results = resultsetNode.getChildren("result");
            for (Object resultObj : results) {
                DetailInfo detailInfo = new DetailInfo();
                BankAcnt acnt = request.getAcnt();
                detailInfo.setAccNo(acnt.getAccNo());
                detailInfo.setAccName(acnt.getAccName());
                Element resultNode = (Element)resultObj;
                String transDateStr = resultNode.getChildTextTrim("TransDate");
                LocalDate transDate = LocalDate.parse(transDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                detailInfo.setTransDate(transDate);
                detailInfo.setTransTime(transDate.atStartOfDay());
                detailInfo.setSerialNo(Integer.valueOf(Integer.parseInt(resultNode.getChildTextTrim("TransNo"))));
                detailInfo.setTransType(resultNode.getChildTextTrim("TransType"));
                detailInfo.setReceiptNo(resultNode.getChildTextTrim("CheckNo"));
                detailInfo.setOppAccNo(resultNode.getChildTextTrim("OppAccountCode"));
                detailInfo.setOppAccName(resultNode.getChildTextTrim("OppAccountName"));
                detailInfo.setOppBankName(resultNode.getChildTextTrim("OppBankName"));
                String side = resultNode.getChildTextTrim("Side");
                if (PropertiesConstants.getValue((String)"CREDIT").equals(side)) {
                    detailInfo.setCreditAmount(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildTextTrim("Amount")));
                    detailInfo.setDebitAmount(new BigDecimal(0));
                } else if (PropertiesConstants.getValue((String)"DEBIT").equals(side)) {
                    detailInfo.setDebitAmount(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildTextTrim("Amount")));
                    detailInfo.setCreditAmount(new BigDecimal(0));
                }
                detailInfo.setExplanation(resultNode.getChildTextTrim("Uses"));
                detailInfo.setUseCn(resultNode.getChildTextTrim("Description"));
                detailInfo.setCurrency(request.getBankCurrency());
                detailInfos.add(detailInfo);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u5931\u8d25 :%s\u3002", (String)"NorincoParser_7", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{retCode, responseNode.getChild("result").getChildTextTrim("errMsg")}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public static EBBankDetailResponse parseTodayDetail(BankDetailRequest request, String rspStr) {
        Element root = NorincoParser.parseString2Root(rspStr);
        Element responseNode = root.getChild("response");
        String retCode = responseNode.getChild("result").getChildTextTrim("retCode");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        if ("0".equals(retCode)) {
            Element resultsetNode = responseNode.getChild("resultset");
            List results = resultsetNode.getChildren("result");
            for (Object resultObj : results) {
                DetailInfo detailInfo = new DetailInfo();
                BankAcnt acnt = request.getAcnt();
                detailInfo.setAccNo(acnt.getAccNo());
                detailInfo.setAccName(acnt.getAccName());
                detailInfo.setTransDate(request.getStartDate());
                Element resultNode = (Element)resultObj;
                detailInfo.setAccNo(resultNode.getChildTextTrim("AccountCode"));
                String transDateStr = resultNode.getChildTextTrim("TransDate");
                LocalDate transDate = LocalDate.parse(transDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                detailInfo.setTransDate(transDate);
                detailInfo.setTransTime(transDate.atStartOfDay());
                detailInfo.setSerialNo(Integer.valueOf(Integer.parseInt(resultNode.getChildTextTrim("TransNo"))));
                detailInfo.setTransType(resultNode.getChildTextTrim("TransType"));
                detailInfo.setReceiptNo(resultNode.getChildTextTrim("CheckNo"));
                detailInfo.setOppAccNo(resultNode.getChildTextTrim("OppAccountCode"));
                detailInfo.setOppAccName(resultNode.getChildTextTrim("OppAccountName"));
                detailInfo.setOppBankName(resultNode.getChildTextTrim("OppBankName"));
                String side = resultNode.getChildTextTrim("Side");
                if (PropertiesConstants.getValue((String)"CREDIT").equals(side)) {
                    detailInfo.setCreditAmount(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildTextTrim("Amount")));
                    detailInfo.setDebitAmount(new BigDecimal(0));
                } else if (PropertiesConstants.getValue((String)"DEBIT").equals(side)) {
                    detailInfo.setDebitAmount(BigDecimalHelper.str2BigDecimal((String)resultNode.getChildTextTrim("Amount")));
                    detailInfo.setCreditAmount(new BigDecimal(0));
                }
                detailInfo.setExplanation(resultNode.getChildTextTrim("Uses"));
                detailInfo.setUseCn(resultNode.getChildTextTrim("Description"));
                detailInfo.setCurrency(request.getBankCurrency());
                detailInfos.add(detailInfo);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4eca\u65e5\u660e\u7ec6\u5931\u8d25 :%s\u3002", (String)"NorincoParser_8", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{retCode, responseNode.getChild("result").getChildTextTrim("errMsg")}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public static EBBankPayResponse parseTransactionPay(BankPayRequest request, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        EBBankPayResponse response = new EBBankPayResponse();
        Element root = NorincoParser.parseString2Root(rspStr);
        Element responseNode = root.getChild("response");
        Element resultNode = responseNode.getChild("result");
        String retCode = resultNode.getChildTextTrim("retCode");
        if ("0".equals(retCode) || "1".equals(retCode) || "2".equals(retCode)) {
            String tranFlag = resultNode.getChildTextTrim("TranFlag");
            String errMsg = resultNode.getChildTextTrim("errMsg");
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)retCode, (String)(StringUtils.isNotEmpty((String)tranFlag) ? tranFlag : errMsg));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)retCode, (String)resultNode.getChildTextTrim("errMsg"));
        }
        response.setPaymentInfos(Collections.singletonList(paymentInfo));
        return response;
    }

    public static EBBankPayResponse parseQueryTransactionPay(BankPayRequest request, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        EBBankPayResponse response = new EBBankPayResponse();
        Element root = NorincoParser.parseString2Root(rspStr);
        Element responseNode = root.getChild("response");
        Element resultNode = responseNode.getChild("result");
        String retCode = resultNode.getChildTextTrim("retCode");
        String errMsg = resultNode.getChildTextTrim("errMsg");
        String description = resultNode.getChildTextTrim("Description");
        if ("1".equalsIgnoreCase(retCode) || "2".equalsIgnoreCase(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"NorincoParser_3", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), (String)retCode, (String)(StringUtils.isNotEmpty((String)description) ? description : errMsg));
        } else if ("0".equalsIgnoreCase(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"NorincoParser_4", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), (String)retCode, (String)(StringUtils.isNotEmpty((String)description) ? description : errMsg));
        } else if ("3".equalsIgnoreCase(retCode) || "4".equalsIgnoreCase(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)retCode, (String)resultNode.getChildTextTrim("errMsg"));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"NorincoParser_5", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), (String)retCode, (String)(StringUtils.isNotEmpty((String)description) ? description : errMsg));
        }
        response.setPaymentInfos(Collections.singletonList(paymentInfo));
        return response;
    }
}

