/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cqb.dc.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQB_DC_Parser {
    public static EBBankDetailResponse parseDetail(BankDetailRequest bankDetailRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (!errorCode.equalsIgnoreCase("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"CQB_DC_Parser_9", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), errorCode, errorMsg));
        }
        Element body = root.getChild("body");
        List trans = body.getChildren("Trans");
        if (CollectionUtil.isEmpty((Collection)trans)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < trans.size(); ++i) {
            Element element = (Element)trans.get(i);
            String transDate = element.getChildTextTrim("TransDate");
            String transTime = element.getChildTextTrim("TransTime");
            String transMark = element.getChildTextTrim("TransMark");
            String voucherType = element.getChildTextTrim("VoucherType");
            String voucherNo = element.getChildTextTrim("VoucherNo");
            String transAmt = element.getChildTextTrim("TransAmt");
            String acctAmt = element.getChildTextTrim("AcctAmt");
            String oppAcct = element.getChildTextTrim("OppAcct");
            String oppName = element.getChildTextTrim("OppName");
            String summary = element.getChildTextTrim("Summary");
            String transSeqNo = element.getChildTextTrim("TransSeqNo");
            DetailInfo detailInfo = new DetailInfo();
            BankAcnt acnt = bankDetailRequest.getAcnt();
            detailInfo.setAccNo(acnt.getAccNo());
            detailInfo.setAccName(acnt.getAccName());
            detailInfo.setBankName(acnt.getBankName());
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detailInfo.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            if ("+".equalsIgnoreCase(transMark)) {
                detailInfo.setCreditAmount(new BigDecimal(transAmt));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else if ("-".equalsIgnoreCase(transMark)) {
                detailInfo.setDebitAmount(new BigDecimal(transAmt));
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u8bc6\uff1a%1$s\u4e0d\u7b26\u5408\u9884\u671f\u3002", (String)"CQB_DC_Parser_10", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), transMark));
            }
            detailInfo.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)acctAmt, (Boolean)true));
            detailInfo.setOppAccNo(oppAcct);
            detailInfo.setOppAccName(oppName);
            detailInfo.setExplanation(summary);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(transSeqNo);
            list.add(detailInfo);
        }
        return new EBBankDetailResponse(list);
    }

    public static EBBankPayResponse parseBatchPay(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (errorCode.equalsIgnoreCase("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"CQB_DC_Parser_5", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), (String)errorCode, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"CQB_DC_Parser_5", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)errorCode, (String)errorMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQueryBatchPay(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (!errorCode.equalsIgnoreCase("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)errorCode, (String)errorMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        List trans = body.getChildren("Trans");
        Element element = (Element)trans.get(0);
        String tstatus = element.getChildTextTrim("Tstatus");
        String failureRea = element.getChildTextTrim("FailureRea");
        if ("1".equalsIgnoreCase(tstatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CQB_DC_Parser_6", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), (String)tstatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CQB_DC_Parser_6", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]));
        } else if ("3".equalsIgnoreCase(tstatus) || "5".equalsIgnoreCase(tstatus) || "7".equalsIgnoreCase(tstatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)failureRea, (String)tstatus, (String)failureRea);
        } else if ("4".equalsIgnoreCase(tstatus) || "2".equalsIgnoreCase(tstatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CQB_DC_Parser_7", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), (String)tstatus, (String)failureRea);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)failureRea, (String)tstatus, (String)failureRea);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

