/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cqb.dc.services.balance;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cqb.dc.services.CQB_DC_Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        return CQB_DC_Packer.createBalanceMessage(acnt.getAccNo());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return this.parseTodayBalance(bankBalanceRequest, s);
    }

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (!errorCode.equalsIgnoreCase("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"CQB_DC_Parser_8", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), errorCode, errorMsg));
        }
        BalanceInfo balanceinfo = new BalanceInfo();
        Element body = root.getChild("body");
        Element trans = body.getChild("Trans");
        String accountNo = trans.getChildTextTrim("AccountNo");
        String customNm = trans.getChildTextTrim("CustomNm");
        String Currency = trans.getChildTextTrim("Currency");
        String Amount = trans.getChildTextTrim("Amount");
        String UseableAmt = trans.getChildTextTrim("UseableAmt");
        BankAcnt bankacnt = new BankAcnt();
        bankacnt.setAccNo(accountNo);
        bankacnt.setAccName(customNm);
        balanceinfo.setBankAcnt(bankacnt);
        if (Currency.equalsIgnoreCase("01")) {
            Currency = "CNY";
        }
        this.setBankAcnt(balanceinfo, bankBalanceRequest.getBankAcntList(), accountNo);
        this.setCurrentBalance(balanceinfo, Amount);
        this.setBankCurrency(balanceinfo, Currency);
        this.setAvailableBalance(balanceinfo, UseableAmt);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceinfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "4402";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]);
    }
}

