/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.opa.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.opa.service.Check;
import kd.ebg.aqap.banks.spdb.opa.service.Packer;
import kd.ebg.aqap.banks.spdb.opa.service.ParserRsp;
import kd.ebg.aqap.banks.spdb.opa.service.Signature;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        return this.packNormalTodayBalance(request);
    }

    private String packNormalTodayBalance(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"unfSocCrdtNo", (String)RequestContextUtils.getBankParameterValue((String)"unfSocCrdtNo"));
        Element lists = JDomUtils.addChild((Element)body, (String)"lists");
        lists.setAttribute("name", "acctList");
        Element list = JDomUtils.addChild((Element)lists, (String)"list");
        bankAcntList.forEach(accNo -> JDomUtils.addChild((Element)list, (String)"acctNo", (String)StringLength.fixed((String)accNo.getAccNo(), (String)"", (int)20, (boolean)false)));
        return Packer.packToReqMsg("EYC2", body);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        return this.parserNormalTodayBalance(request, responseStr);
    }

    private EBBankBalanceResponse parserNormalTodayBalance(BankBalanceRequest rqst, String rspStr) {
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        int length = localList.size();
        log.info("\u94f6\u884c\u8fd4\u56de" + length + "\u4e2a\u8d26\u6237\u4f59\u989d\u7ed3\u679c");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(length);
        BankAcnt acnt = rqst.getAcnt();
        for (int i = 0; i < length; ++i) {
            BigDecimal aviBal;
            Element element = (Element)localList.get(i);
            String acctNo = ParserUtils.getUnNullElementTextValue((Element)element, (String)"acctNo", (String)ResManager.loadKDString((String)"\u8d26\u53f7", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
            if (!acnt.getAccNo().equals(acctNo)) {
                log.info("\u94f6\u884c\u8fd4\u56de\u8d26\u53f7" + acctNo + "\u548c\u63d0\u4ea4\u8bf7\u6c42\u8d26\u53f7" + acnt.getAccNo() + "\u4e0d\u4e00\u81f4,\u8be5\u6761\u660e\u7ec6\u8bb0\u5f55\u8ba4\u4e3a\u65e0\u6548");
                continue;
            }
            String masterID = element.getChildTextTrim("masterID");
            String balStr = ParserUtils.checkUnNullableElement((Element)element, (String)"balance");
            String reserveBalance = element.getChildTextTrim("reserveBalance");
            String freezeBalance = element.getChildTextTrim("freezeBalance");
            String cortrolBalance = element.getChildTextTrim("cortrolBalance");
            String canUseBalance = element.getChildTextTrim("canUseBalance");
            String overdraftBalance = element.getChildTextTrim("overdraftBalance");
            log.info("\u5e10\u53f7\uff1a" + acctNo);
            log.info("\u5ba2\u6237\u53f7\uff1a" + masterID);
            log.info("\u5e10\u53f7\u4f59\u989d\uff1a" + balStr);
            log.info("\u4fdd\u7559\u4f59\u989d\uff1a" + reserveBalance);
            log.info("\u51bb\u7ed3\u4f59\u989d\uff1a" + freezeBalance);
            log.info("\u63a7\u5236\u4f59\u989d\uff1a" + cortrolBalance);
            log.info("\u53ef\u7528\u91d1\u989d\uff1a" + canUseBalance);
            log.info("\u900f\u652f\u4f59\u989d\uff1a" + overdraftBalance);
            BalanceInfo balance = new BalanceInfo();
            balance.setBankAcnt(acnt);
            BigDecimal currBal = this.convert(balStr);
            if (null != currBal) {
                balance.setCurrentBalance(currBal);
            }
            if (null != (aviBal = this.convert(canUseBalance))) {
                balance.setAvailableBalance(aviBal);
            }
            balance.setBalanceDateTime(LocalDateTime.now());
            balance.setBankCurrency(rqst.getBankCurrency());
            balances.add(balance);
        }
        return new EBBankBalanceResponse(balances);
    }

    private BigDecimal convert(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            return new BigDecimal(str);
        }
        return null;
    }

    public String getDeveloper() {
        return "congmin_huang";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u5e10\u6237\u4f59\u989d\u67e5\u8be2(EYC2)", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d(EYC2)", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]);
    }
}

