/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000002_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000002_ReceiveItem;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000002_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000002_SendItem;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.constants.BSZConstants;
import kd.ebg.aqap.banks.bsz.dc.helper.Dealer;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000002
implements IMiniService<Root<Header4Send, OPCB000002_Send>, Root<Header4Receive, OPCB000002_Receive>, List<PaymentInfo>, List<PaymentInfo>> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000002.class);
    public static String transCode = "OPCB000002";

    public static OPCB000002 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000002_Send> getSendRoot(List<PaymentInfo> paymentInfos) throws Exception {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        OPCB000002_Send body = new OPCB000002_Send();
        body.setCSTNO(RequestContextUtils.getBankParameterValue((String)"CST_NO"));
        body.setPAYER_ACCT_NO(paymentInfo.getAccNo());
        body.setPAYER_NAME(paymentInfo.getAccName());
        body.setTOTALAMT(Utils.getTotalAmount(paymentInfos));
        body.setTOTALNUM(String.valueOf(paymentInfos.size()));
        ArrayList<OPCB000002_SendItem> items = new ArrayList<OPCB000002_SendItem>(1);
        for (PaymentInfo info : paymentInfos) {
            OPCB000002_SendItem item = new OPCB000002_SendItem();
            item.setORDERFLOW_NO(info.getDetailBizNo());
            if (!info.is2SameBank()) {
                item.setPAYEE_OPEN_BRANCH_ID(info.getIncomeCnaps());
                item.setPAYEE_OPEN_BRANCH_NAME(info.getIncomeBankAddress());
            }
            item.setPAYEE_ACCT_NO(info.getIncomeAccNo());
            item.setPAYEE_NAME(info.getIncomeAccName());
            item.setCCY(info.getCurrency());
            item.setPAYEE_ACCT_TYPE(info.is2Individual() ? "1" : "0");
            item.setTRAN_TYPE(Dealer.chooseTransType(info, true));
            item.setTRAN_AMT(info.getAmount().toString());
            item.setUSAGE(info.getUseCn());
            item.setPOSTSCRIPT(info.getExplanation());
            items.add(item);
        }
        body.setACCT_ARRAY(items);
        Root<Header4Send, OPCB000002_Send> root = new Root<Header4Send, OPCB000002_Send>();
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000002_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000002_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<PaymentInfo> recvStrategy(Root<Header4Receive, OPCB000002_Receive> root, List<PaymentInfo> paymentInfos) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000002_Receive body = root.getBody();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"body\u8282\u70b9\u4e0d\u5b58\u5728", (String)"OPCB000002_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000002_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        String BATCH_NO = Utils.nullAsBlank(body.getBATCH_NO());
        if (!StringUtils.isNotEmpty((String)BATCH_NO)) {
            logger.error("\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2dBATCH_NO\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2dBATCH_NO\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000002_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"BATCH_NO", (String)BATCH_NO);
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"PAY_TRANSCODE", (String)this.getTransCode());
        OPCB000002.setBankRefId(paymentInfos, BATCH_NO);
        List<OPCB000002_ReceiveItem> items = body.getRESULT_ARRAY();
        for (OPCB000002_ReceiveItem item : items) {
            String bodyStatusCode = Utils.nullAsBlank(item.getORDER_STATE());
            String bodyStatusExpr = Utils.nullAsBlank(BSZConstants.STATUS_MAP.get(bodyStatusCode).loadKDString());
            if (StringUtils.isEmpty((String)bodyStatusExpr)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522b\u72b6\u6001\u7801%s", (String)"OPCB000002_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode), (String)headStatusCode, (String)headStatusMsg);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522bbody\u72b6\u6001\u7801\uff1a%s", (String)"OPCB000002_4", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode));
            }
            String statusMsg = Utils.nullAsBlank(item.getRET_MESSAGE());
            String orderFlowNo = Utils.nullAsBlank(item.getORDER_FLOWNO());
            PaymentInfo info = Utils.selectPaymentrInfoFromBatch(paymentInfos, orderFlowNo);
            if (info == null) {
                logger.error("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5339\u914d\u7684\u6d41\u6c34\uff1a" + orderFlowNo);
                continue;
            }
            if (bodyStatusCode.equals("90")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
                continue;
            }
            if (bodyStatusCode.equals("91")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)bodyStatusExpr, (String)bodyStatusCode, (String)statusMsg);
        }
        return paymentInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    public static void setBankRefId(List<PaymentInfo> paymentInfos, String bankRefId) {
        for (PaymentInfo info : paymentInfos) {
            info.setBankRefID(bankRefId);
        }
    }

    private static class Holder {
        private static final OPCB000002 instance = new OPCB000002();

        private Holder() {
        }
    }
}

