/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000003_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000003_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class OPCB000003
implements IMiniService<Root<Header4Send, OPCB000003_Send>, Root<Header4Receive, OPCB000003_Receive>, BankBalanceRequest, EBBankBalanceResponse> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000003.class);
    public static String transCode = "OPCB000003";

    public static OPCB000003 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000003_Send> getSendRoot(BankBalanceRequest rqst) {
        Root<Header4Send, OPCB000003_Send> root = new Root<Header4Send, OPCB000003_Send>();
        OPCB000003_Send body = new OPCB000003_Send();
        body.setCLIENT_ACCT_NO(rqst.getAcnt().getAccNo());
        if (BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo())) {
            String ACCT_SERIAL_NO = BankBusinessConfig.getFixAccSerialNo(rqst.getAcnt().getAccNo());
            body.setACCT_SERIAL_NO(ACCT_SERIAL_NO);
        }
        body.setCCY(rqst.getBankCurrency());
        if (Objects.equals(rqst.getBankCurrency(), "156")) {
            body.setCA_TT_FLAG("1");
        } else {
            body.setCA_TT_FLAG("2");
        }
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000003_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000003_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public EBBankBalanceResponse recvStrategy(Root<Header4Receive, OPCB000003_Receive> root, BankBalanceRequest rqst) throws Exception {
        BalanceInfo balance = new BalanceInfo();
        BankAcnt bankAcnt = new BankAcnt();
        Header4Receive header = root.getHeader();
        OPCB000003_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000003_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        String accName = Utils.nullAsBlank(body.getACCT_NAME());
        String accNo = Utils.nullAsBlank(body.getCLIENT_ACCT_NO());
        String balanceStr = Utils.nullAsBlank(body.getPRESENT_BALANCE());
        String aviBalanceStr = Utils.nullAsBlank(body.getTODAY_AVAIL_AMT());
        String currency = Utils.nullAsBlank(body.getCCY());
        logger.info("\u4f59\u989d\u4fe1\u606f.\u8fd4\u56de\u8d26\u53f7:" + accNo + ",\u4f59\u989d:" + balanceStr + ",\u53ef\u7528\u989d\u5ea6:" + aviBalanceStr);
        balance.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balanceStr, (Boolean)false));
        balance.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)aviBalanceStr, (Boolean)true));
        bankAcnt.setAccName(accName);
        bankAcnt.setAccNo(accNo);
        balance.setBankAcnt(bankAcnt);
        balance.setBalanceDateTime(LocalDateTime.now());
        balance.setBankCurrency(currency);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    private static class Holder {
        private static final OPCB000003 instance = new OPCB000003();

        private Holder() {
        }
    }
}

