/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements IBatchBalance,
HXB_DC_Constants {
    public String pack(BankBalanceRequest request) {
        List acnts = request.getBankAcntList();
        int sendNumber = acnts.size();
        StringBuilder sb = new StringBuilder();
        sb.append("xhj0010").append('#').append(String.valueOf(sendNumber)).append('#');
        StringBuilder accNos = new StringBuilder();
        for (int i = 0; i < sendNumber; ++i) {
            String accNo = ((BankAcnt)acnts.get(i)).getAccNo();
            accNos.append(accNo).append('|');
        }
        sb.append((CharSequence)accNos);
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        ArrayList<BalanceInfo> infos;
        responseStr = ResponseStrUtil.process(responseStr);
        String[] array = StringUtils.split((String)responseStr, (int)35);
        ArrayList<String> list = new ArrayList<String>(16);
        for (String s : array) {
            if (StringUtils.isEmpty((String)s.trim()) || s.trim().equalsIgnoreCase("@@@@")) continue;
            list.add(s);
        }
        array = list.toArray(new String[0]);
        if (array.length < 2) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u5f02\u5e38\uff0c\u5207\u5206\u7684\u5b57\u7b26\u4e32\u6570\u7ec4\u957f\u5ea6\u5c0f\u4e8e2\uff0c\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a:%s\u3002", (String)"BatchBalanceImpl_9", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), responseStr);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String responseCode = array[0];
        EBBankBalanceResponse batchBalanceResponse = new EBBankBalanceResponse();
        if ("000000".equalsIgnoreCase(responseCode)) {
            String rec = array[1];
            int recNumber = Integer.parseInt(rec);
            infos = new ArrayList<BalanceInfo>(1);
            String bankCurrency = request.getBankCurrency();
            for (int i = 0; i < recNumber; ++i) {
                BalanceInfo info = new BalanceInfo();
                this.setBankCurrency(info, bankCurrency);
                String detail = array[i + 2];
                String[] details = StringUtils.split((String)detail, (int)124);
                ArrayList<String> temp = new ArrayList<String>(16);
                for (String s : details) {
                    if (!StringUtils.isNotEmpty((String)s)) continue;
                    temp.add(s);
                }
                details = temp.toArray(new String[0]);
                String accNo = details[0];
                String currentBalance = details[1];
                String availableBalance = details[2];
                this.setBankAcnt(info, request.getBankAcntList(), accNo);
                this.setCurrentBalance(info, currentBalance);
                this.setAvailableBalance(info, availableBalance);
                this.setBalanceDateTime(info, LocalDateTime.now());
                infos.add(info);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)responseCode, (String)""));
        }
        batchBalanceResponse.setBalances(infos);
        return batchBalanceResponse;
    }

    public int limit() {
        return 50;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankBalanceRequest request) {
        if (request.getStartDate() != null) {
            return LocalDate.now().equals(request.getStartDate());
        }
        return false;
    }
}

