/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.authorized;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.authorized.AuthorizedQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AuthorizedPayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorizedQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "xhj8004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7f51\u94f6\u6388\u6743\u652f\u4ed8", (String)"AuthorizedPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BankBusinessConfig.isPaymentByAuthorized();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymenInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("xhj8004");
        sb.append('#');
        sb.append(paymenInfo.getBankDetailSeqId());
        sb.append('#');
        sb.append(paymenInfo.getAccNo());
        sb.append('#');
        sb.append(paymenInfo.getAmount().setScale(2, 5).toString());
        sb.append('#');
        sb.append(paymenInfo.getIncomeAccNo());
        sb.append('#');
        sb.append(paymenInfo.getIncomeAccName());
        sb.append('#');
        if (paymenInfo.is2SameBank()) {
            sb.append("4");
        } else if ("big".equalsIgnoreCase(BankBusinessConfig.getTransChannal())) {
            sb.append("0");
        } else if ("same".equalsIgnoreCase(BankBusinessConfig.getTransChannal())) {
            sb.append("1");
        } else {
            sb.append("3");
        }
        sb.append('#');
        sb.append(paymenInfo.getIncomeCnaps());
        sb.append('#');
        sb.append(paymenInfo.getIncomeBankName());
        sb.append('#');
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            if (!StringUtils.isEmpty((String)paymenInfo.getExplanation())) {
                sb.append(Packer.getKDExp(paymenInfo));
            } else {
                sb.append(Packer.getKDExp(paymenInfo, ""));
            }
        } else {
            sb.append(paymenInfo.getExplanation());
        }
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        try {
            String responseCode = elements[0];
            if ("EL4471".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"AuthorizedPayImpl_2", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"EL4471", (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536\u5f85\u5ba1\u6838\u3002", (String)"AuthorizedPayImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)responseCode, (String)String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6\uff1a%s\u3002", (String)"AuthorizedPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), responseCode));
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)(PaymentState.UNKNOWN.getCnName() + "\uff1a" + e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

