/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.otherbank;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymenInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("xhj8045");
        sb.append('#');
        sb.append(paymenInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        sb.append('#');
        sb.append(paymenInfo.getBankBatchSeqID());
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String responseCode = elements[0];
        if ("000000".equalsIgnoreCase(responseCode)) {
            Map<String, BankResponse> bankResponseMap = this.getBankResult(elements);
            for (PaymentInfo info : paymentInfos) {
                BankResponse result = bankResponseMap.get(info.getBankDetailSeqID());
                if (null == result) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u6ca1\u627e\u5bf9\u5e94\u8be5\u8d26\u6237\u7684\u4ea4\u6613\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"", (String)"");
                    continue;
                }
                if ("01".equalsIgnoreCase(result.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getResponseMessage());
                    continue;
                }
                if ("02".equalsIgnoreCase(result.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getResponseMessage());
                    continue;
                }
                if ("03".equalsIgnoreCase(result.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualQueryPayImpl_9", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private Map<String, BankResponse> getBankResult(String[] records) {
        HashMap<String, BankResponse> resultMap = new HashMap<String, BankResponse>();
        int length = records.length;
        int limit = length - 1;
        for (int i = 14; i < limit; ++i) {
            String record = records[i];
            String[] details = StringUtils.split((String)record, (String)"|");
            if (details.length < 21) continue;
            String seq = details[0];
            String status = details[11];
            String errorCode = details[12];
            String failReason = details[13];
            BankResponse bankResponse = new BankResponse();
            bankResponse.setResponseCode(status);
            bankResponse.setResponseMessage(errorCode + failReason);
            resultMap.put(seq, bankResponse);
        }
        return resultMap;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj8045";
    }

    public String getBizDesc() {
        return null;
    }
}

