/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.services.payment;

import kd.ebg.aqap.banks.bjrcb.cmp.services.Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public static final String trade_code = "300001";

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element ap_root = new Element("ap");
        JDomUtils.addChild((Element)ap_root, (Element)Packer.getCommonHead(trade_code, "0", paymentInfo));
        JDomUtils.addChild((Element)ap_root, (Element)this.getPaymentInfoBody(paymentInfo));
        String rqstStr = JDomUtils.element2StringPlain((Element)ap_root, (String)"GB18030");
        rqstStr = Packer.packSendMsg(rqstStr, "0");
        return rqstStr;
    }

    private Element getPaymentInfoBody(PaymentInfo paymentInfo) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        String currencyBank = paymentInfo.getCurrency();
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)currencyBank);
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno");
        JDomUtils.addChild((Element)body, (String)"as_acname");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)paymentInfo.getBankAddress());
        JDomUtils.addChild((Element)body, (String)"cert_type");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)currencyBank);
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"prv_flag", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bank_kind");
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getUseCn());
        JDomUtils.addChild((Element)body, (String)"postscript");
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date");
        JDomUtils.addChild((Element)body, (String)"booking_time");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfo.getMobiles());
        return body;
    }
}

