/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final PropertyConfigItem CCB_CCIP_SALARY_SELECT = PropertyConfigItem.builder().key("SALARY_SELECT").mlName(new MultiLangEnumBridge("\u5173\u8054\u63a5\u53e3", "BankBusinessConfig_14", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5df2\u5bf9\u63a5\u7684\u4ee3\u53d1\u4e1a\u52a1\u63a5\u53e3:", "BankBusinessConfig_15", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("1)\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3(P1CLP1051);", "BankBusinessConfig_18", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("2)\u666e\u901a\u8f6c\u8d26\u63a5\u53e3(P1CMSET35)(\u9700\u5728\u4ed8\u6b3e\u4e1a\u52a1\u53c2\u6570\u3010\u4ee3\u53d1\u8f6c\u666e\u901a\u8f6c\u8d26\u63a5\u53e3\u4ed8\u6b3e\u3011\u9009\u62e9\u201c\u662f\u201d\u624d\u80fd\u542f\u7528\u6b64\u529f\u80fd);", "BankBusinessConfig_19", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3(P1CLP1051)", "BankBusinessConfig_17", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u666e\u901a\u8f6c\u8d26\u63a5\u53e3(P1CMSET35)", "BankBusinessConfig_29", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"P1CLP1051", "P1CMSET35"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"P1CLP1051"})).mustInput(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem CCB_CCIP_ENTRST_PRJ_ID = PropertyConfigItem.builder().key("CCB_CCIP_ENTRST_PRJ_ID").mlName(new MultiLangEnumBridge("\u59d4\u6258\u9879\u76ee\u7f16\u53f7", "BankBusinessConfig_4", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u4ee3\u6263\u7f16\u53f7\uff08BILL_CODE\uff09\uff1a\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1/\u5bf9\u79c1\u4ed8\u6b3e\u4e1a\u52a1\u4f7f\u7528\u3002", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1aP1CLP1051\uff08\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\uff09\u63a5\u53e3Entrst_Prj_ID\uff08\u59d4\u6258\u9879\u76ee\u7f16\u53f7\uff09\u3002", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u5907\u6ce8\uff1a\u76f4\u8fde\u5ba2\u6237\u7684\u4ee3\u6536\u4ed8\u5408\u7ea6\u5728\u7b7e\u7ea6\u65f6\u7b7e\u7ea6\u9879\u76ee\u7684\u9879\u76ee\u7f16\u53f7\u3002", "BankBusinessConfig_9", "ebg-aqap-banks-ccb-ccip")})).isAccNo(true).build();
    private static final PropertyConfigItem CCB_CCIP_IS_AUTHORITY = PropertyConfigItem.builder().key("CCB_CCIP_IS_AUTHORITY").mlName(new MultiLangEnumBridge("\u666e\u901a\u4ed8\u6b3e\u662f\u5426\u9009\u62e9\u4e8c\u6b21\u5ba1\u6838\u652f\u4ed8\u3002", "BankBusinessConfig_12", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u4ed8\u6b3e\u662f\u5426\u9009\u62e9\u4e8c\u6b21\u5ba1\u6838\u652f\u4ed8\uff1a", "BankBusinessConfig_39", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("1)\u662f\uff1a\u4f7f\u7528\u4e8c\u6b21\u5ba1\u6838\u652f\u4ed8\u63a5\u53e3\uff08P1CMSETB0\uff09", "BankBusinessConfig_40", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("2)\u5426\uff1a\u4e0d\u4f7f\u7528\u4e8c\u6b21\u5ba1\u6838\uff0c\u4f7f\u7528\u666e\u901a\u4ed8\u6b3e\u63a5\u53e3\uff08P1CMSET35\uff09\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_41", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_10", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_11", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem CCB_CCIP_IndividualToCompany = PropertyConfigItem.builder().key("CCB_CCIP_IndividualToCompany").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u8f6c\u666e\u901a\u8f6c\u8d26\u63a5\u53e3\u4ed8\u6b3e", "BankBusinessConfig_16", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u91c7\u7528\u4ee3\u53d1\u8f6c\u666e\u901a\u8f6c\u8d26\u63a5\u53e3\u4ed8\u6b3e\u65b9\u5f0f\uff1a", "BankBusinessConfig_42", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("1)\u662f\uff1a\u4ee3\u53d1(P1CLP1051)\u8f6c\u4e3a\u666e\u901a\u8f6c\u8d26\u4ed8\u6b3e(\u5373\u5bf9\u79c1\u4ed8\u6b3e\u5c06\u8d70\u666e\u901a\u8f6c\u8d26\u63a5\u53e3(P1CMSET35)\u8fdb\u884c\u4ed8\u6b3e)", "BankBusinessConfig_43", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("2)\u5426\uff1a\u4ee3\u53d1\u4e0d\u8f6c\u666e\u901a\u8f6c\u8d26\u4ed8\u6b3e\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_44", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_10", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_11", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem CCB_CCIP_CURRENT_BALANCE = PropertyConfigItem.builder().key("CCB_CCIP_CURRENT_BALANCE").mlName(new MultiLangEnumBridge("\u5f53\u524d\u4f59\u989d\u53d6\u503c\u9009\u62e9", "BankBusinessConfig_27", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u5e10\u53f7\u7684\u5f53\u524d\u4f59\u989d \u662f\u5426\u4f7f\u7528 \u4fe1\u606f\u62a5\u544a\u8d26\u6237\u4f59\u989d\u5b57\u6bb5\uff08InfRpt_AcBa\uff09\u7684\u503c:", "BankBusinessConfig_50", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("1)\u5f53\u524d\u4f59\u989d=\u4fe1\u606f\u62a5\u544a\u8d26\u6237\u4f59\u989d", "BankBusinessConfig_51", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("2)\u5f53\u524d\u4f59\u989d=\u53ef\u7528\u4f59\u989d\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_52", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4fe1\u606f\u62a5\u544a\u8d26\u6237\u4f59\u989d", "BankBusinessConfig_31", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u53ef\u7528\u4f59\u989d", "BankBusinessConfig_32", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_ccip_detail_choose = PropertyConfigItem.builder().key("detail_note_select").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c", "BankBusinessConfig_33", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c", "BankBusinessConfig_33", "ebg-aqap-banks-ccb-ccip")})).inputType(ConfigInputType.CLICK_TEXT.getInputType()).isHide(true).build();
    private static final PropertyConfigItem CCB_CCIP_HIS_BALANCE_SHOW_AVLBAL = PropertyConfigItem.builder().key("CCB_CCIP_HIS_BALANCE_SHOW_AVLBAL").mlName(new MultiLangEnumBridge("\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u662f\u5426\u663e\u793a\u53ef\u7528\u4f59\u989d", "BankBusinessConfig_53", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\uff08P1CMSERA6\uff09\u83b7\u53d6\u4f59\u989d\u540e\uff0c\u662f\u5426\u5c06\u4f59\u989d\u503c\u8d4b\u503c\u7ed9\u53ef\u7528\u4f59\u989d\u5e76\u5728\u7cfb\u7edf\u5185\u663e\u793a\u3002\u9ed8\u8ba4\u4e3a\u663e\u793a\u3002", "BankBusinessConfig_54", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u663e\u793a\u53ef\u7528\u4f59\u989d", "BankBusinessConfig_55", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u4e0d\u663e\u793a\u53ef\u7528\u4f59\u989d", "BankBusinessConfig_56", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"true"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem CCB_CCIP_CZ = PropertyConfigItem.builder().key("CCB_CCIP_CZ").mlName(new MultiLangEnumBridge("\u8d22\u8d44\u7c7b\u8d26\u6237\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u9009\u62e9", "BankBusinessConfig_57", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8d22\u8d44\u7c7b\u8d26\u6237\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u9009\u62e9\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff0c\u5982\u679c\u5df2\u7ecf\u67e5\u8be2\u5386\u53f2\u65e5\u671f\u660e\u7ec6\uff0c\u8981\u6ce8\u610f\u660e\u7ec6\u6570\u636e\u53ef\u80fd\u4f1a\u51fa\u73b0\u91cd\u590d\uff1b", "BankBusinessConfig_58", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("1\uff09P1CMSER65\uff0c\u9ed8\u8ba4\u9009\u9879\uff1b", "BankBusinessConfig_59", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("2\uff09P1CMSERB4", "", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("P1CMSERB4", "", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("P1CMSER65", "", "ebg-aqap-banks-ccb-ccip")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"P1CMSERB4", "P1CMSER65"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"P1CMSER65"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem BATCH_PAY_SIZE = PropertyConfigItem.builder().key("batch_pay_size").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650", "BankBusinessConfig_22", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u63a5\u53e3P1CLP1051\u4e00\u6279\u6700\u5927\u7b14\u6570\uff0c\u9ed8\u8ba4200\uff0c\u8c03\u6574\u524d\u5efa\u8bae\u4e0e\u94f6\u884c\u786e\u8ba4", "BankBusinessConfig_23", "ebg-aqap-banks-ccb-ccip")})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"200"})).set2Integer().mustInput(true).set2MaxValueNum(5000).set2MinValueNum(Integer.valueOf(200)).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem PAYMENT_FIX_SERIAL_NUM = PropertyConfigItem.builder().key("payment_fix_serial_num").mlName(new MultiLangEnumBridge("\u540c\u7b14\u4ed8\u6b3e\u5355\u662f\u5426\u4f7f\u7528\u76f8\u540c\u94f6\u884c\u6d41\u6c34\u53f7", "BankBusinessConfig_34", "ebg-aqap-banks-ccb-ccip")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ec5\u652f\u6301\u5355\u7b14\u63a5\u53e3\uff0c\u540c\u4e00\u7b14\u4ed8\u6b3e\u5355\u63d0\u4ea4\u7ed9\u94f6\u884c\u7684\u591a\u6b21\u4ed8\u6b3e\u6307\u4ee4\uff08\u4f8b\u5982\u5931\u8d25\u91cd\u4ed8\uff09\u53ef\u4ee5\u4f7f\u7528\u94f6\u884c\u6d41\u6c34\u53f7\u52a0\u5f3a\u91cd\u590d\u4ed8\u6b3e\u68c0\u9a8c\uff0c\u5373\u4f7f\u7528\u76f8\u540c\u6d41\u6c34\u53f7.\u63d0\u4ea4\u7ed9\u94f6\u884c\uff0c\u7531\u94f6\u884c\u7aef\u8fdb\u884c\u91cd\u590d\u4ed8\u6b3e\u6821\u9a8c\u3002", "BankBusinessConfig_35", "ebg-aqap-banks-ccb-ccip")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultFalse).mustInput(true).build();

    public String getBankVersionID() {
        return "CCB_CCIP";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List list = this.getBankAddtionalPropertyConfigItems(true, false, false, true, true);
        list.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{CCB_CCIP_CURRENT_BALANCE, PAYMENT_FIX_SERIAL_NUM, CCB_CCIP_ENTRST_PRJ_ID, CCB_CCIP_SALARY_SELECT, CCB_CCIP_IS_AUTHORITY, CCB_CCIP_IndividualToCompany, ccb_ccip_detail_choose, CCB_CCIP_HIS_BALANCE_SHOW_AVLBAL, CCB_CCIP_CZ, BATCH_PAY_SIZE}));
        BankBusinessConfig.specialAccNoTypeMl((List)list, (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankBusinessConfig_0", "ebg-aqap-banks-ccb-ccip"), new MultiLangEnumBridge("\u8d22\u8d44\u7c7b", "BankBusinessConfig_1", "ebg-aqap-banks-ccb-ccip")}), (List)Lists.newArrayList((Object[])new String[]{"normal", "caizi"}));
        return list;
    }

    public static final boolean isCZDetailByB4(String accNo) {
        return PaymentUtils.isCaiziAcnt(accNo) && "P1CMSERB4".equalsIgnoreCase(CCB_CCIP_CZ.getCurrentValue());
    }

    public static boolean hisBalanceShowAvlBal() {
        return Boolean.parseBoolean(CCB_CCIP_HIS_BALANCE_SHOW_AVLBAL.getCurrentValue());
    }

    public static boolean currentBalanceChoose() {
        return Boolean.parseBoolean(CCB_CCIP_CURRENT_BALANCE.getCurrentValue());
    }

    public static boolean isIndividualToCompany() {
        return CCB_CCIP_IndividualToCompany.getCurrentValueAsBoolean();
    }

    public static boolean isAuthority() {
        return CCB_CCIP_IS_AUTHORITY.getCurrentValueAsBoolean();
    }

    public static String getPrjofCode(String payAccNo) {
        return CCB_CCIP_ENTRST_PRJ_ID.getCurrentValueWithObjectID(payAccNo);
    }

    public static boolean isPushWay(String bankLoginID, String customId) {
        String value = BankBusinessConfig.getReceiptConfigValue(bankLoginID, customId, "ccipPushMode");
        return Objects.equals(value, "true");
    }

    public static boolean isUserNewApi(String bankLoginID, String customId) {
        String value = BankBusinessConfig.getReceiptConfigValue(bankLoginID, customId, "downloadReceiptMod");
        return Objects.equals(value, "P1CCMW006");
    }

    private static String getReceiptConfigValue(String bankLoginID, String customId, String configId) {
        BankLoginConfigRepository configRepository = (BankLoginConfigRepository)SpringContextUtil.getBean(BankLoginConfigRepository.class);
        DynamicObject result = configRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLoginID, customId, configId);
        if (result == null) {
            return "";
        }
        return result.getString("bank_config_value");
    }

    public List<LinkPayConfig> getLinkPayConfigs() {
        return Lists.newArrayList((Object[])new LinkPayConfig[]{LinkPayConfig.NATIVE_LINK_PAY, LinkPayConfig.ALLOCATION_AND_PAY});
    }

    public static int getBatchSize() {
        return BATCH_PAY_SIZE.getCurrentValueAsInt();
    }
}

