/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.service.apply;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.service.apply.ApplyPacker;
import kd.ebg.aqap.banks.gdb.opa.util.Parser;
import kd.ebg.aqap.banks.gdb.opa.util.SendUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.common.utils.gdbopa.GDBOpaSMUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class ApplyImpl
extends AbstractApplyImpl
implements IApply {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ApplyImpl.class);

    public String pack(BankApplyRequest bankApplyRequest) {
        if ("D".equalsIgnoreCase(bankApplyRequest.getApplyType())) {
            return ApplyPacker.pack("C", bankApplyRequest.getAcnt().getAccNo(), "");
        }
        String publicKey = RequestContextUtils.getRunningParam((String)"publicKey");
        return ApplyPacker.pack("S", bankApplyRequest.getAcnt().getAccNo(), publicKey);
    }

    public EBBankApplyResponse doBiz(BankApplyRequest rqst) {
        if ("A".equalsIgnoreCase(rqst.getApplyType())) {
            Map keyMap = GDBOpaSMUtil.getSMKey();
            RequestContextUtils.setRunningParam((String)"publicKey", (String)((String)keyMap.get("publicKey")));
            RequestContextUtils.setRunningParam((String)"privateKey", (String)((String)keyMap.get("privateKey")));
        }
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankApplyResponse parse(BankApplyRequest bankApplyRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        String bizName = this.getBizDesc();
        if ("D".equalsIgnoreCase(bankApplyRequest.getApplyType())) {
            bizName = ResManager.loadKDString((String)"\u89e3\u9664\u7b7e\u7ea6", (String)"ApplyImpl_0", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]);
        }
        Parser.parseHeader(jsonObject.getJSONObject("Header"), bizName);
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21%1$s\u4e1a\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8fd4\u56de\u7801:%2$s,\u5f02\u5e38\u4fe1\u606f\uff1a%3$s", (String)"ApplyImpl_9", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), bizName, sysRetCode, sysRetInfo);
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if ("D".equalsIgnoreCase(bankApplyRequest.getApplyType())) {
            return this.parseCancelApply(body);
        }
        return this.parseApply(body, bankApplyRequest.getAcnt());
    }

    private EBBankApplyResponse parseCancelApply(JSONObject body) {
        String authStatus = body.getString("authStatus");
        if ("0".equalsIgnoreCase(authStatus)) {
            return new EBBankApplyResponse(Sequence.gen18Sequence());
        }
        logger.info("\u89e3\u7ea6\u5931\u8d25\uff0c\u5f53\u524d\u94f6\u884c\u8fd4\u56de\u6388\u6743\u7801\u4e3a{}", (Object)authStatus);
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u7ea6\u5931\u8d25", (String)"ApplyImpl_4", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
    }

    private EBBankApplyResponse parseApply(JSONObject body, BankAcnt bankAcnt) {
        String authStatus = body.getString("authStatus");
        String authURL = body.getString("authURL");
        if ("0".equalsIgnoreCase(authStatus)) {
            String publicKey = RequestContextUtils.getRunningParam((String)"publicKey");
            String privateKey = RequestContextUtils.getRunningParam((String)"privateKey");
            GDBOpaSMUtil.saveBankLoginCert((String)publicKey, (String)privateKey, (String)bankAcnt.getBankVersionId(), (String)bankAcnt.getBankLoginId(), (String)bankAcnt.getCustomID());
            logger.info("\u672a\u6388\u6743\u72b6\u6001\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u4e2d\u7684\u79d8\u94a5");
            return new EBBankApplyResponse(Sequence.gen18Sequence(), authURL);
        }
        if ("2".equalsIgnoreCase(authStatus)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f51\u94f6\u5df2\u62d2\u7edd\u6388\u6743\uff01", (String)"ApplyImpl_5", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
        if ("1".equalsIgnoreCase(authStatus)) {
            String entCstNo = body.getString("entCstNo");
            BankLoginConfigService service = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
            service.saveBankLoginConfig("cst_no", entCstNo, bankAcnt.getBankLoginId(), bankAcnt.getCustomID());
            logger.info("\u5df2\u6388\u6743\u6210\u529f\uff0c\u5ba2\u6237\u53f7{}\u66f4\u65b0\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u6210\u529f\uff01", (Object)entCstNo);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5df2\u6388\u6743\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u7b7e\u7ea6\uff01", (String)"ApplyImpl_6", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u6388\u6743\u7801\uff01", (String)"ApplyImpl_7", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "serviceApplyAuth";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u7ea6", (String)"ApplyImpl_8", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]);
    }
}

