/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tfyh.dc.services.payment;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tfyh.dc.services.Packer;
import kd.ebg.aqap.banks.tfyh.dc.services.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final String[] submitedCode = new String[]{"1", "3", "4", "5", "6"};

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6839\u636e\u4ed8\u6b3e\u8d26\u53f7\u67e5\u8be2\u5355\u7b14\u8f6c\u8d26\u4ea4\u6613\u7ed3\u679c\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u3002", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]));
        }
        Element request = Packer.buildTranHead("QueryTransfer", paymentInfo.getBankDetailSeqId());
        Element body = request.getChild("body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"voucherType", (String)"1");
        String billCode = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"billCode");
        if (StringUtils.isEmpty((String)billCode)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u5355\u636e\u53f7billCode\u4e3a\u7a7a\u3002", (String)"QryPaymentImpl_8", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)entity, (String)"billCode", (String)billCode);
        return JDomUtils.root2String((Element)request, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!StringUtils.isEmpty((String)bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u540c\u6b65\u5931\u8d25 :%s\u3002", (String)"QryPaymentImpl_7", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        Element body = root.getChild("body");
        Element entity = JDomUtils.getChildElement((Element)body, (String)"entity");
        String billCode = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"billCode");
        if (!billCode.equals(JDomUtils.getChildText((Element)entity, (String)"billCode"))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u540c\u6b65\u5931\u8d25 :\u5355\u636e\u53f7(billCode)\u8fd4\u56de\u7684\u4e0d\u5339\u914d\u3002", (String)"QryPaymentImpl_2", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]));
        }
        Element list = body.getChild("list");
        String retCode = JDomUtils.getChildText((Element)list, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)list, (String)"retMsg");
        String bankRetCode = JDomUtils.getChildText((Element)list, (String)"bankRetCode");
        String bankRetMsg = JDomUtils.getChildText((Element)list, (String)"bankRetMsg");
        String msg = retMsg + "," + bankRetMsg;
        if ("0".equals(bankRetCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryPaymentImpl_3", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)bankRetCode, (String)msg);
        } else if ("2".equals(bankRetCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryPaymentImpl_4", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)bankRetCode, (String)msg);
        } else if (Arrays.asList(submitedCode).contains(bankRetCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryPaymentImpl_5", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)bankRetCode, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryPaymentImpl_6", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)bankRetCode, (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QueryTransfer";
    }

    public String getBizDesc() {
        return null;
    }
}

