/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static final String BATCHFILEHEDAER = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");

    public static LocalDate parseDate(String str) {
        return LocalDate.parse(str, DATE_FORMATTER);
    }

    public static String formatTime(LocalTime localTime) {
        return localTime.format(TIME_FORMATTER);
    }

    public static String formatDate(LocalDate localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static String formatDate(LocalDateTime localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static LocalDateTime parseDateTime(String str) {
        return LocalDateTime.parse(str, DATE_TIME_FORMATTER);
    }

    public static Element buildHead(String code, String seqNo) {
        return Packer.buildHead(code, seqNo, false);
    }

    public static Element buildHead(String code, String seqNo, boolean file) {
        Element root = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)seqNo);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)Packer.formatDate(LocalDate.now()));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)Packer.formatTime(LocalTime.now()));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)(file ? "1" : "0"));
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return root;
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = 0;
        String charsetName = EBContext.getContext().getCharsetName();
        try {
            length = xmlStr.getBytes(charsetName).length;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u6587\u957f\u5ea6\u5f02\u5e38\uff0c\u5b57\u7b26\u96c6\uff1a%s\u3002", (String)"Packer_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), charsetName), (Throwable)e);
        }
        return Strings.padStart((String)String.valueOf(length + 2), (int)10, (char)'0') + "00" + xmlStr;
    }

    public static String packerBalanceXML(BankBalanceRequest request, String code) {
        String charsetName = EBContext.getContext().getCharsetName();
        Element root = Packer.buildHead(code, Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)charsetName);
        return Packer.buildCommonMsg(xmlStr);
    }
}

