/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.balance;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String accType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        return Packer.packerBalanceXML(request, Objects.equals(accType, "cashpool") ? "220203" : "200108");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String accType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String acno = body.getChildTextTrim("acno");
        String cur_code = request.getBankCurrency();
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        if (!request.getAcnt().getAccNo().equals(acno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(cur_code);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isEmpty((String)balance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        String recv = super.recv(inputStream);
        return recv.substring(12);
    }
}

