/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.payment.company;

import java.math.BigDecimal;
import java.util.Date;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.HSBL_DC_Packer;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.HSBL_DC_Utils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element simulator = new Element("simulator");
        Element head = HSBL_DC_Packer.createHead("BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileType", (String)"string");
        JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ftp");
        JDomUtils.addChild((Element)reqPara, (String)"connectCustomerID", (String)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.connectCustomerID));
        JDomUtils.addChild((Element)reqPara, (String)"netCustomerID", (String)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.netCustomerID));
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            String accNo = paymentInfos[i].getAccNo();
            String name = paymentInfos[i].getAccName();
            JDomUtils.addChild((Element)list, (String)"acntNo", (String)accNo);
            if (!StringUtils.isEmpty((String)BankBusinessConfig.getAcntName(accNo))) {
                name = BankBusinessConfig.getAcntName(accNo);
            }
            JDomUtils.addChild((Element)list, (String)"acntName", (String)name);
            JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
            JDomUtils.addChild((Element)list, (String)"acntBankName", (String)paymentInfos[i].getBankName());
            JDomUtils.addChild((Element)list, (String)"acntCountry", (String)paymentInfos[i].getAccCountry());
            JDomUtils.addChild((Element)list, (String)"acntProvince", (String)paymentInfos[i].getAccProvince());
            JDomUtils.addChild((Element)list, (String)"acntCity", (String)paymentInfos[i].getAccCity());
            JDomUtils.addChild((Element)list, (String)"acntBankBranchNo", (String)paymentInfos[i].getAreaCode());
            JDomUtils.addChild((Element)list, (String)"acntBankCnapsNo", (String)"");
            JDomUtils.addChild((Element)list, (String)"currency", (String)paymentInfos[i].getCurrency());
            Date now = new Date();
            JDomUtils.addChild((Element)list, (String)"startDate", (String)DateTimeUtils.format((Date)now, (String)"yyyyMMdd"));
            JDomUtils.addChild((Element)list, (String)"startTime", (String)DateTimeUtils.format((Date)now, (String)"HHmmss"));
            String ysPaymentDetail = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[i], (String)"ysPaymentDetail");
            ysPaymentDetail = HSBL_DC_Utils.replaceInvalidChar(ysPaymentDetail);
            JDomUtils.addChild((Element)list, (String)"detailRemark", (String)ysPaymentDetail);
            if (!BankBusinessConfig.isChooseEBG() && !StringUtils.isEmpty((String)ysPaymentDetail)) {
                String[] str = ysPaymentDetail.split("\\r?\\n")[0].split("\uff0c");
                String serialNo = str[0].substring(0, str[0].lastIndexOf("-"));
                JDomUtils.addChild((Element)list, (String)"serialNo", (String)serialNo);
                paymentInfos[i].setBankDetailSeqID(serialNo);
            } else {
                JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
            }
            JDomUtils.addChild((Element)list, (String)"txAmt", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getAmount()));
            JDomUtils.addChild((Element)list, (String)"urgentFlag", (String)(paymentInfos[i].is2Urgent() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameBankFlag", (String)(paymentInfos[i].is2SameBank() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameCityFlag", (String)(paymentInfos[i].is2SameCity() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"payType", (String)(true == paymentInfos[i].is2Individual() ? "individual" : "company"));
            JDomUtils.addChild((Element)list, (String)"email", (String)paymentInfos[i].getEmails());
            JDomUtils.addChild((Element)list, (String)"oppAcntNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)list, (String)"oppAcntName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)list, (String)"oppAcntNameEN", (String)"");
            JDomUtils.addChild((Element)list, (String)"oppBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)list, (String)"oppAcntCountry", (String)paymentInfos[i].getIncomeCountry());
            JDomUtils.addChild((Element)list, (String)"oppAcntProvince", (String)paymentInfos[i].getIncomeProvince());
            JDomUtils.addChild((Element)list, (String)"oppAcntCity", (String)paymentInfos[i].getIncomeCity());
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)paymentInfos[i].getIncomeAreaCode());
            JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)paymentInfos[i].getIncomeSwiftCode());
            JDomUtils.addChild((Element)list, (String)"useCode", (String)"");
            String explanation = paymentInfos[i].getExplanation();
            JDomUtils.addChild((Element)list, (String)"explanation", (String)HSBL_DC_Utils.replaceInvalidChar(explanation));
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }
}

