/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.account;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.common.entity.biz.acct.MappingAcctReqBody;
import kd.ebg.aqap.common.entity.biz.acct.MappingAcctRequest;
import kd.ebg.aqap.common.entity.biz.acct.MappingAcctResponse;
import kd.ebg.aqap.common.entity.biz.acct.MappingTable;
import kd.ebg.aqap.common.model.repository.MappingAcctRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MappingAcctMethod
implements EBServiceMethod<MappingAcctRequest, MappingAcctResponse> {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(MappingAcctMethod.class);

    public MappingAcctRequest mappingCurrency(MappingAcctRequest request) {
        List mappingTables = request.getBody().getTables();
        HashMap currencyMap = new HashMap(16);
        for (MappingTable mt : mappingTables) {
            List list = mt.getChildAccts();
            list.stream().forEach(item -> {
                String currency = item.getCurrency();
                currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
                item.setCurrency(currency);
            });
        }
        return request;
    }

    public MappingAcctResponse mappingCurrency(MappingAcctResponse response) {
        if (response.getBody() != null) {
            List mappingTables = response.getBody().getTables();
            HashMap currencyMap = new HashMap(16);
            for (MappingTable mt : mappingTables) {
                List list = mt.getChildAccts();
                list.stream().forEach(item -> {
                    String currency = item.getCurrency();
                    currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(currency, currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public MappingAcctResponse executeClientRequest(MappingAcctRequest mappingAcctRequest, EBContext ebContext) throws MalformedURLException {
        MappingAcctRepository acctRepository = (MappingAcctRepository)SpringContextUtil.getBean(MappingAcctRepository.class);
        MappingAcctReqBody body = mappingAcctRequest.getBody();
        List mappingTables = body.getTables();
        for (MappingTable mt : mappingTables) {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)mt.getParentAcct()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7236\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MappingAcctMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            List childAccts = mt.getChildAccts();
            for (MappingTable.TableStruct ts : childAccts) {
                Preconditions.checkArgument((!StringUtils.isEmpty((String)ts.getAccNo()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5b50\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MappingAcctMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((!StringUtils.isEmpty((String)ts.getCurrency()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"MappingAcctMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            try (TXHandle h = TX.requiresNew();){
                acctRepository.delete(mt.getParentAcct());
                acctRepository.save(mt);
            }
        }
        return new MappingAcctResponse(mappingTables);
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "syncMappedAcct";
    }
}

