/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.business.balancereconciliation.atomic.IQueryBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.QueryReconciliationUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationCommonUtil;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliation;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.QueryBalanceReconciliationRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.QueryBalanceReconciliationResponse;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.QueryBalanceReconciliationResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryBalanceReconciliationMethod
implements EBServiceMethod<QueryBalanceReconciliationRequest, QueryBalanceReconciliationResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBalanceReconciliationMethod.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);
    private static int maxQueryNum = 200;

    public QueryBalanceReconciliationRequest mappingCurrency(QueryBalanceReconciliationRequest request) {
        String currency = request.getBody().getCurrency();
        currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency);
        request.getBody().setCurrency(currency);
        return request;
    }

    public QueryBalanceReconciliationResponse mappingCurrency(QueryBalanceReconciliationResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getBalanceReconciliations();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public QueryBalanceReconciliationResponse executeClientRequest(QueryBalanceReconciliationRequest request, EBContext context) {
        boolean exitsQueryMethod;
        AccessUtils.checkQueryAllowed(context);
        String monthStr = request.getBody().getMonth();
        LocalDate month = ReconciliationCommonUtil.checkMonth(monthStr);
        ArrayList<BalanceReconciliation> balanceReconciliations = new ArrayList<BalanceReconciliation>(16);
        String currency = request.getBody().getCurrency();
        if (StringUtils.isEmpty((String)currency)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"QueryBalanceReconciliationMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        List accNos = request.getBody().getAccNos();
        if (CollectionUtils.isEmpty((Collection)accNos)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"QueryBalanceReconciliationMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (accNos.size() > 1000) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u7b14\u6570\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"QueryBalanceReconciliationMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        List<BankAcnt> bankAcnts = ReconciliationCommonUtil.checkBankAcnts(accNos, balanceReconciliations, currency, monthStr);
        List details = this.balanceDetailRepository.findByCurrencyAndMonthAndAccNos(currency, month, accNos);
        if (CollectionUtils.isEmpty((Collection)details)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u5728%s\u65e0\u53ef\u53cd\u9988\u7684\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"QueryBalanceReconciliationMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), monthStr));
        }
        ArrayList<BalanceReconciliationDetail> queryDetails = new ArrayList<BalanceReconciliationDetail>(1);
        for (BalanceReconciliationDetail detail : details) {
            String accNo = detail.getAccNo();
            accNos.remove(accNo);
            if ("0".equals(detail.getHandleStatus())) {
                String error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u672a\u53cd\u9988\uff0c\u65e0\u6cd5\u540c\u6b65\u53cd\u9988\u72b6\u6001\u3002", (String)"QueryBalanceReconciliationMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u672a\u53cd\u9988\uff0c\u65e0\u6cd5\u540c\u6b65\u53cd\u9988\u72b6\u6001\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
                balanceReconciliations.add(ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, monthStr, error));
                continue;
            }
            if (BalanceReconciliationState.SUBMITED.getId() == detail.getStatusId().intValue() || BalanceReconciliationState.UNKNOWN.getId() == detail.getStatusId().intValue()) {
                String statusName = BalanceReconciliationState.getEnumById(detail.getStatusId()).getCnName();
                if (detail.getQueryNum() >= maxQueryNum) {
                    this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u72b6\u6001\u4e3a{}\uff0c\u4f46\u5927\u4e8e\u6700\u5927\u540c\u6b65\u6b21\u6570{}\uff0c\u4e0d\u518d\u8bf7\u6c42\u94f6\u884c", new Object[]{accNo, monthStr, statusName, maxQueryNum});
                } else {
                    this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u72b6\u6001\u4e3a{}\uff0c\u9700\u8bf7\u6c42\u94f6\u884c\u540c\u6b65\u53cd\u9988\u72b6\u6001", new Object[]{accNo, monthStr, statusName});
                    queryDetails.add(detail);
                }
            } else if (BalanceReconciliationState.PACKAGED.getId() == detail.getStatusId().intValue() && detail.getUpdateTime().plusMinutes(20L).isBefore(LocalDateTime.now())) {
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u72b6\u6001\u4e3a{}\uff0c\u4f46\u5904\u7406\u65f6\u95f4\u8d85\u8fc720\u5206\u949f\uff0c\u7f6e\u4e3a\u53cd\u9988\u5f02\u5e38\u72b6\u6001", new Object[]{accNo, monthStr, BalanceReconciliationState.PACKAGED.getCnName()});
                ReconciliationBusinessUtil.setBalanceReconciliationState(detail, BalanceReconciliationState.FAIL, "", ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u8d85\u65f6", (String)"QueryBalanceReconciliationMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                this.balanceDetailRepository.updateAll(Collections.singletonList(detail));
            }
            BalanceReconciliation balanceReconciliation = this.buildBalanceReconciliation(detail);
            balanceReconciliations.add(balanceReconciliation);
        }
        if (CollectionUtils.isNotEmpty((Collection)accNos)) {
            for (String accNo : accNos) {
                String error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u65e0\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"QueryBalanceReconciliationMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                balanceReconciliations.add(ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, monthStr, error));
                this.logger.info("\u68c0\u6d4b\u5230\u8d26\u53f7{}\u5728{}\u65e0\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
            }
        }
        if (exitsQueryMethod = this.exitsQueryMethod(bankAcnts.get(0).getBankVersionId())) {
            Map<String, List<BalanceReconciliationDetail>> groupMap = ReconciliationCommonUtil.groupByBankLoginId(queryDetails);
            new QueryReconciliationUtil().async(groupMap);
        } else {
            this.logger.info("\u68c0\u6d4b\u5230\u94f6\u884c\u7248\u672c{}\u5728\u4e0d\u5b58\u5728\u540c\u6b65\u4f59\u989d\u5bf9\u8d26\u72b6\u6001\u65b9\u6cd5\uff0c\u4e0d\u505a\u67e5\u8be2\u94f6\u884c\u64cd\u4f5c\uff0c\u76f4\u63a5\u8fd4\u56de\u6570\u636e\u5e93\u8bb0\u5f55", (Object)bankAcnts.get(0).getBankVersionId());
        }
        QueryBalanceReconciliationResponseBody body = new QueryBalanceReconciliationResponseBody();
        body.setBalanceReconciliations(balanceReconciliations);
        return new QueryBalanceReconciliationResponse(body);
    }

    private boolean exitsQueryMethod(String bankVersionID) {
        boolean exitsQueryMethod = true;
        try {
            IQueryBalanceReconciliation reconciliation = (IQueryBalanceReconciliation)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryBalanceReconciliation.class, null);
            if (reconciliation == null) {
                exitsQueryMethod = false;
            }
        }
        catch (Exception ex) {
            exitsQueryMethod = false;
        }
        return exitsQueryMethod;
    }

    private BalanceReconciliation buildBalanceReconciliation(BalanceReconciliationDetail detail) {
        BalanceReconciliation balanceReconciliation = new BalanceReconciliation();
        balanceReconciliation.setAccNo(detail.getAccNo());
        balanceReconciliation.setMonth(detail.getMonth());
        balanceReconciliation.setBalance(detail.getBalance());
        balanceReconciliation.setBankStatus(detail.getBankStatus());
        balanceReconciliation.setBankStatusMsg(detail.getBankStatusMsg());
        balanceReconciliation.setCheckStatus(detail.getCheckStatus());
        balanceReconciliation.setHandleStatus(Integer.valueOf(Integer.parseInt(detail.getHandleStatus())));
        balanceReconciliation.setStatus(detail.getStatus());
        balanceReconciliation.setStatusName(detail.getStatusName());
        return balanceReconciliation;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryBalanceStatement";
    }
}

