/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationCommonUtil;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.UpdateBalanceReconciliationStatus;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.UpdateBalanceReconciliationStatusRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.UpdateBalanceReconciliationStatusResponse;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.UpdateBalanceReconciliationStatusResponseBody;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class UpdateBalanceReconciliationStatusMethod
implements EBServiceMethod<UpdateBalanceReconciliationStatusRequest, UpdateBalanceReconciliationStatusResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(UpdateBalanceReconciliationStatusMethod.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);

    public UpdateBalanceReconciliationStatusResponse executeClientRequest(UpdateBalanceReconciliationStatusRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        String monthStr = request.getBody().getMonth();
        LocalDate month = ReconciliationCommonUtil.checkMonth(monthStr);
        List accNos = request.getBody().getAccNos();
        if (CollectionUtils.isEmpty((Collection)accNos)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"UpdateBalanceReconciliationStatusMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (accNos.size() > 1000) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u7b14\u6570\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"UpdateBalanceReconciliationStatusMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        String currency = request.getBody().getCurrency();
        if (StringUtils.isEmpty((String)currency)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"UpdateBalanceReconciliationStatusMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)request.getBody().getStatus())) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5bf9\u8d26\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"UpdateBalanceReconciliationStatusMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (!BalanceReconciliationState.OTHER.getEnName().equals(request.getBody().getStatus())) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u4fee\u6539\u4e3a\u5176\u4ed6\u9014\u5f84\u53cd\u9988\u72b6\u6001\u3002", (String)"UpdateBalanceReconciliationStatusMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        ArrayList<UpdateBalanceReconciliationStatus> statuses = new ArrayList<UpdateBalanceReconciliationStatus>(1);
        this.checkBankAcnts(accNos, statuses, currency, monthStr);
        List details = this.balanceDetailRepository.findByCurrencyAndMonthAndAccNos(currency, month, accNos);
        if (CollectionUtils.isEmpty((Collection)details)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u5728%s\u65e0\u53ef\u53cd\u9988\u7684\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"UpdateBalanceReconciliationStatusMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]), monthStr));
        }
        ArrayList<BalanceReconciliationDetail> handleDetails = new ArrayList<BalanceReconciliationDetail>(1);
        for (BalanceReconciliationDetail detail : details) {
            String accNo = detail.getAccNo();
            accNos.remove(accNo);
            String error = "";
            UpdateBalanceReconciliationStatus status = this.getUpdateBalanceReconciliationStatus(accNo, currency, monthStr, error);
            if ("0".equals(detail.getHandleStatus())) {
                detail.setHandleStatus("1");
                ReconciliationBusinessUtil.updateBalanceReconciliationState(detail, BalanceReconciliationState.OTHER);
                detail.setOperator(request.getBody().getOperator());
                detail.setReason(request.getBody().getUpdateReason());
                handleDetails.add(detail);
                status.setStatus(BalanceReconciliationState.OTHER.getEnName());
            } else {
                error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u5df2\u53cd\u9988\uff0c\u72b6\u6001\u4fee\u6539\u5931\u8d25\u3002", (String)"UpdateBalanceReconciliationStatusMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u5df2\u53cd\u9988\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
                status.setError(error);
            }
            statuses.add(status);
        }
        if (CollectionUtils.isNotEmpty((Collection)accNos)) {
            for (String accNo : accNos) {
                String error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u65e0\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"UpdateBalanceReconciliationStatusMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                statuses.add(this.getUpdateBalanceReconciliationStatus(accNo, currency, monthStr, error));
                logger.info("\u68c0\u6d4b\u5230\u8d26\u53f7{}\u5728{}\u65e0\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
            }
        }
        this.saveBalanceReconciliationDetails(handleDetails);
        UpdateBalanceReconciliationStatusResponseBody body = new UpdateBalanceReconciliationStatusResponseBody();
        body.setDetails(statuses);
        return new UpdateBalanceReconciliationStatusResponse(body);
    }

    private void saveBalanceReconciliationDetails(List<BalanceReconciliationDetail> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            TXHandle h = TX.requiresNew();
            try {
                this.balanceDetailRepository.updateAll(details);
            }
            catch (Exception ex) {
                h.markRollback();
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u8bb0\u5f55\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\u3002", (String)"UpdateBalanceReconciliationStatusMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)ex);
            }
            finally {
                try {
                    h.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public List<BankAcnt> checkBankAcnts(List<String> accNos, List<UpdateBalanceReconciliationStatus> details, String currency, String month) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        Iterator<String> iterator = accNos.iterator();
        while (iterator.hasNext()) {
            String accNo = iterator.next();
            BankAcnt acnt = BankAcntService.getInstance().selectEnableByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            if (null == acnt) {
                details.add(this.getUpdateBalanceReconciliationStatus(accNo, currency, month, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u672a\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\u6216\u5df2\u5220\u9664\u3002", (String)"UpdateBalanceReconciliationStatusMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0])));
                logger.info("\u68c0\u67e5\u5230\u672a\u7ef4\u62a4\u7684\u94f6\u884c\u8d26\u53f7{}\uff0c\u8fd4\u56deerror", (Object)accNo);
                iterator.remove();
                continue;
            }
            bankAcnts.add(acnt);
        }
        if (bankAcnts.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8d26\u53f7\u5217\u8868\u5728\u94f6\u4f01\u4e91\u91cc\u5747\u4e0d\u5b58\u5728\u3002", (String)"UpdateBalanceReconciliationStatusMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return bankAcnts;
    }

    private UpdateBalanceReconciliationStatus getUpdateBalanceReconciliationStatus(String accNo, String currency, String month, String error) {
        UpdateBalanceReconciliationStatus updateBalanceReconciliationStatus = new UpdateBalanceReconciliationStatus();
        updateBalanceReconciliationStatus.setError(error);
        updateBalanceReconciliationStatus.setAccNo(accNo);
        updateBalanceReconciliationStatus.setCurrency(currency);
        updateBalanceReconciliationStatus.setMonth(month);
        return updateBalanceReconciliationStatus;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u4f59\u989d\u5bf9\u8d26\u72b6\u6001\u3002", (String)"UpdateBalanceReconciliationStatusMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }
}

